/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.plugin.mongovariant;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JMenuItem;
import org.broad.igv.dev.api.IGVPlugin;
import org.broad.igv.plugin.mongovariant.VariantReviewDialog;
import org.broad.igv.plugin.mongovariant.VariantReviewSource;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackClickEvent;
import org.broad.igv.track.TrackMenuItemBuilder;
import org.broad.igv.track.TrackMenuUtils;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.PanelName;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.variant.Variant;
import org.broad.igv.variant.VariantTrack;
import org.broad.igv.variant.vcf.VCFVariant;
import org.broadinstitute.variant.variantcontext.VariantContext;

public class VariantReviewPlugin
implements IGVPlugin {
    private static final String SHOW_REVIEW_KEY = "SHOW_VARIANT_REVIEW";
    private static boolean hasReviewTrack = false;
    private static boolean showReviewOption = Boolean.parseBoolean(IGV.getInstance().getSession().getPersistent("SHOW_VARIANT_REVIEW", "false"));
    private static final String DB_PATH_KEY = "VARIANT_DB_PATH";
    public static final String DB_PATH_DEFAULT = "resources/NA12878kb.json";
    private static final String PREFERENTIAL_SAMPLE_KEY = "PREFERENTIAL_SAMPLE";
    public static final String DEFAULT_PREFERENTIAL_SAMPLE = "NA12878";
    private static String preferentialSampleName;
    private static String dbSpecPath;

    @Override
    public void init() {
        if (showReviewOption) {
            this.initMenuItems();
        }
    }

    private void initMenuItems() {
        TrackMenuUtils.addTrackMenuItemBuilder(new TrackMenuItemBuilder(){

            @Override
            public JMenuItem build(Collection<Track> selectedTracks, TrackClickEvent te) {
                JMenuItem showReviewMenuItem = new JMenuItem("Load Review Track");
                showReviewMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ArrayList<Track> newTracks = new ArrayList<Track>(1);
                        ResourceLocator locator = new ResourceLocator(VariantReviewPlugin.getDbSpecPath());
                        locator.setName("NA12878 KB");
                        VariantReviewSource.loadVariantReview(locator, newTracks);
                        IGV.getInstance().addTracks(newTracks, PanelName.DATA_PANEL);
                        hasReviewTrack = true;
                    }
                });
                showReviewMenuItem.setEnabled(!hasReviewTrack);
                return showReviewMenuItem;
            }
        });
        TrackMenuUtils.addTrackMenuItemBuilder(new TrackMenuItemBuilder(){

            @Override
            public JMenuItem build(Collection<Track> selectedTracks, TrackClickEvent te) {
                if (selectedTracks.size() != 1) {
                    return null;
                }
                Track track = selectedTracks.iterator().next();
                if (!(track instanceof VariantTrack)) {
                    return null;
                }
                VariantTrack vTrack = (VariantTrack)track;
                final Variant variant = vTrack.getSelectedVariant(te);
                JMenuItem addReviewMenuItem = new JMenuItem("Submit Review to DB");
                addReviewMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        VariantContext vc = VCFVariant.getVariantContext(variant);
                        new VariantReviewDialog(IGV.getMainFrame(), vc).setVisible(true);
                    }
                });
                addReviewMenuItem.setEnabled(variant != null);
                return addReviewMenuItem;
            }
        });
    }

    public static String getPreferentialSampleName() {
        if (preferentialSampleName == null) {
            preferentialSampleName = IGV.getPersistent(PREFERENTIAL_SAMPLE_KEY, DEFAULT_PREFERENTIAL_SAMPLE);
        }
        return preferentialSampleName;
    }

    public static String getDbSpecPath() {
        if (dbSpecPath == null) {
            dbSpecPath = IGV.getPersistent(DB_PATH_KEY, DB_PATH_DEFAULT);
        }
        return dbSpecPath;
    }
}

