/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.peaks;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.samtools.seekablestream.SeekableBufferedStream;
import net.sf.samtools.seekablestream.SeekableStream;
import net.sf.samtools.seekablestream.SeekableStreamFactory;
import org.broad.igv.peaks.Peak;
import org.broad.igv.util.CompressionUtils;
import org.broad.tribble.util.LittleEndianInputStream;

public class PeakParser {
    Map<String, Long> chrIndex;
    int nTimePoints;
    String path;
    String trackLine;
    int[] times;
    String signalsPath;
    String[] timeSignalsPath;
    private final CompressionUtils compressionUtils;

    public PeakParser(String path) throws IOException {
        this.path = path;
        this.loadHeader();
        this.compressionUtils = new CompressionUtils();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadHeader() throws IOException {
        SeekableStream ss = null;
        try {
            int t;
            ss = SeekableStreamFactory.getStreamFor(this.path);
            LittleEndianInputStream is = new LittleEndianInputStream(new BufferedInputStream(ss));
            long indexPosition = is.readLong();
            this.trackLine = is.readString();
            this.nTimePoints = is.readInt();
            this.times = new int[this.nTimePoints];
            for (t = 0; t < this.nTimePoints; ++t) {
                this.times[t] = is.readInt();
            }
            this.signalsPath = is.readString();
            this.timeSignalsPath = new String[this.nTimePoints];
            for (t = 0; t < this.nTimePoints; ++t) {
                this.timeSignalsPath[t] = is.readString();
            }
            this.chrIndex = new HashMap<String, Long>();
            ss.seek(indexPosition);
            is = new LittleEndianInputStream(new BufferedInputStream(ss));
            int nChrs = is.readInt();
            for (int i = 0; i < nChrs; ++i) {
                String chr = is.readString();
                long pos = is.readLong();
                this.chrIndex.put(chr, pos);
            }
        }
        finally {
            if (ss != null) {
                ss.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Peak> loadPeaks(String chr) throws IOException {
        Long chrPos = this.chrIndex.get(chr);
        if (chrPos == null) {
            return new ArrayList<Peak>();
        }
        ArrayList<Peak> peaks = new ArrayList<Peak>(10000);
        LittleEndianInputStream reader = null;
        SeekableStream ss = null;
        try {
            ss = SeekableStreamFactory.getStreamFor(this.path);
            int bufferSize = 512000;
            long contentLength = ss.length();
            if (contentLength > 0L) {
                bufferSize = (int)Math.min(contentLength, (long)bufferSize);
            }
            SeekableBufferedStream bufferedStream = new SeekableBufferedStream(ss, bufferSize);
            bufferedStream.seek(chrPos);
            reader = new LittleEndianInputStream(bufferedStream);
            int nBytes = reader.readInt();
            byte[] compressedBytes = new byte[nBytes];
            bufferedStream.readFully(compressedBytes);
            byte[] bytes = this.compressionUtils.decompress(compressedBytes);
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            reader = new LittleEndianInputStream(bis);
            String chrRecorded = reader.readString();
            if (!chrRecorded.equals(chr)) {
                throw new RuntimeException("Error paring peak file: " + this.path + "<br>Expected: " + chr + "  found: " + chrRecorded);
            }
            int nDataPoints = reader.readInt();
            for (int n = 0; n < nDataPoints; ++n) {
                int start = reader.readInt();
                int end = reader.readInt();
                float combinedScore = reader.readFloat();
                float[] timePointScores = new float[this.nTimePoints];
                for (int i = 0; i < this.nTimePoints; ++i) {
                    timePointScores[i] = reader.readFloat();
                }
                peaks.add(new Peak(chr, start, end, "", combinedScore, timePointScores));
            }
            ArrayList<Peak> arrayList = peaks;
            return arrayList;
        }
        finally {
            if (ss != null) {
                ss.close();
            }
        }
    }
}

