/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.tribble;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.feature.AbstractCacher;
import org.broad.igv.feature.WrappedIterator;
import org.broad.tribble.CloseableTribbleIterator;
import org.broad.tribble.Feature;
import org.broad.tribble.FeatureReader;

public class CachingFeatureReader
extends AbstractCacher
implements FeatureReader {
    private static Logger log = Logger.getLogger(CachingFeatureReader.class);
    private static int maxBinCount = 1000;
    private static int defaultBinSize = 16000;
    private FeatureReader reader;

    public CachingFeatureReader(FeatureReader reader) {
        this(reader, maxBinCount, defaultBinSize);
    }

    public CachingFeatureReader(FeatureReader reader, int binCount, int binSize) {
        super(binCount, binSize);
        this.reader = reader;
    }

    @Override
    protected Iterator<Feature> queryRaw(String chr, int start, int end) throws IOException {
        return this.reader.query(chr, start, end);
    }

    @Override
    public List<String> getSequenceNames() {
        return this.reader.getSequenceNames();
    }

    @Override
    public Object getHeader() {
        return this.reader.getHeader();
    }

    public CloseableTribbleIterator query(String chr, int start, int end) throws IOException {
        return new WrappedIterator<Feature>(this.queryCached(chr, start, end));
    }

    public CloseableTribbleIterator iterator() throws IOException {
        return this.reader.iterator();
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.reader.close();
    }
}

