/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.Exon;
import org.broad.igv.feature.IGVFeature;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.tribble.Feature;

public class FeatureUtils {
    private static final Comparator<Feature> FEATURE_CONTAINS_COMPARATOR = new Comparator<Feature>(){

        @Override
        public int compare(Feature o1, Feature o2) {
            int genomeStart1;
            int genomeStart2 = o2.getStart();
            if (genomeStart2 >= (genomeStart1 = o1.getEnd()) && o2.getEnd() <= o1.getEnd()) {
                return 0;
            }
            return genomeStart1 - genomeStart2;
        }
    };
    public static final Comparator<Feature> FEATURE_START_COMPARATOR = new Comparator<Feature>(){

        @Override
        public int compare(Feature o1, Feature o2) {
            return o1.getStart() - o2.getStart();
        }
    };

    public static Predicate<Feature> getOverlapPredicate(final String chr, final int start, final int end) {
        Predicate<Feature> overlapPredicate = new Predicate<Feature>(){

            @Override
            public boolean apply(Feature object) {
                return chr.equals(object.getChr()) && object.getStart() <= end && object.getEnd() >= start;
            }
        };
        return overlapPredicate;
    }

    public static Map<String, List<IGVFeature>> divideByChromosome(List<IGVFeature> features) {
        LinkedHashMap<String, List<IGVFeature>> featureMap = new LinkedHashMap<String, List<IGVFeature>>();
        for (IGVFeature f : features) {
            ArrayList<IGVFeature> flist = (ArrayList<IGVFeature>)featureMap.get(f.getChr());
            if (flist == null) {
                flist = new ArrayList<IGVFeature>();
                featureMap.put(f.getChr(), flist);
            }
            flist.add(f);
        }
        return featureMap;
    }

    public static List<List<IGVFeature>> segregateFeatures(List<IGVFeature> features, double scale) {
        ArrayList<List<IGVFeature>> segmentedLists = new ArrayList<List<IGVFeature>>();
        LinkedList<IGVFeature> workingList = new LinkedList<IGVFeature>(features);
        FeatureUtils.sortFeatureList(workingList);
        while (workingList.size() > 0) {
            LinkedList<IGVFeature> nonOverlappingFeatures = new LinkedList<IGVFeature>();
            LinkedList<IGVFeature> overlappingFeatures = new LinkedList<IGVFeature>();
            IGVFeature f1 = (IGVFeature)workingList.remove(0);
            nonOverlappingFeatures.add(f1);
            while (workingList.size() > 0) {
                int scaledEnd;
                IGVFeature f2 = (IGVFeature)workingList.remove(0);
                int scaledStart = (int)((double)f2.getStart() / scale);
                if (scaledStart > (scaledEnd = (int)((double)f1.getEnd() / scale))) {
                    nonOverlappingFeatures.add(f2);
                    f1 = f2;
                    continue;
                }
                overlappingFeatures.add(f2);
            }
            segmentedLists.add(nonOverlappingFeatures);
            workingList = overlappingFeatures;
        }
        return segmentedLists;
    }

    public static void sortFeatureList(List<? extends Feature> features) {
        Collections.sort(features, FEATURE_START_COMPARATOR);
    }

    public static <T extends Feature> List<T> combineSortedFeatureListsNoDups(List<T> self, List<T> other, int start, int end) {
        if (self == null && other == null) {
            return null;
        }
        if (self == null) {
            return other;
        }
        if (other == null) {
            return self;
        }
        return FeatureUtils.combineSortedFeatureListsNoDups(self.iterator(), other.iterator(), start, end);
    }

    public static <T extends Feature> List<T> combineSortedFeatureListsNoDups(Iterator<T> selfIter, Iterator<T> otherIter, int start, int end) {
        ArrayList<Feature> allFeatures = new ArrayList<Feature>();
        Feature otherFeat = null;
        while (otherIter.hasNext() && (otherFeat = (Feature)otherIter.next()).getEnd() <= start) {
            allFeatures.add(otherFeat);
        }
        while (selfIter.hasNext()) {
            allFeatures.add((Feature)selfIter.next());
        }
        while (otherIter.hasNext()) {
            if (otherFeat.getStart() >= end) {
                allFeatures.add(otherFeat);
            }
            otherFeat = (Feature)otherIter.next();
        }
        if (otherFeat != null && otherFeat.getStart() >= end) {
            allFeatures.add(otherFeat);
        }
        return allFeatures;
    }

    public static Feature getFeatureAt(double position, int buffer, List<? extends Feature> features) {
        int startIdx = 0;
        int endIdx = features.size();
        while (startIdx != endIdx) {
            int idx = (startIdx + endIdx) / 2;
            Feature feature = features.get(idx);
            int effectiveStart = feature.getStart();
            int effectiveEnd = feature.getEnd();
            if (position >= (double)(effectiveStart - buffer)) {
                if (position <= (double)(effectiveEnd + buffer)) {
                    return features.get(idx);
                }
                if (idx == startIdx) {
                    return null;
                }
                startIdx = idx;
                continue;
            }
            endIdx = idx;
        }
        return null;
    }

    public static Feature getFeatureAfter(double position, List<? extends Feature> features) {
        int idx;
        if (features.size() == 0 || (double)features.get(features.size() - 1).getStart() <= position) {
            return null;
        }
        int startIdx = 0;
        int endIdx = features.size();
        while (startIdx != endIdx) {
            idx = (startIdx + endIdx) / 2;
            double distance = (double)features.get(idx).getStart() - position;
            if (distance <= 0.0) {
                startIdx = idx;
            } else {
                endIdx = idx;
            }
            if (endIdx - startIdx >= 10) continue;
            break;
        }
        for (idx = startIdx; idx < features.size(); ++idx) {
            if (!((double)features.get(idx).getStart() > position)) continue;
            return features.get(idx);
        }
        return null;
    }

    public static Feature getFeatureBefore(double position, List<? extends Feature> features) {
        for (int index = FeatureUtils.getIndexBefore(position, features); index >= 0; --index) {
            Feature f = features.get(index);
            if (!((double)f.getStart() < position)) continue;
            return f;
        }
        return null;
    }

    public static Feature getFeatureClosest(double position, List<? extends Feature> features) {
        Feature f0 = FeatureUtils.getFeatureAt(position, features);
        if (f0 != null) {
            return f0;
        }
        Feature f1 = FeatureUtils.getFeatureBefore(position, features);
        Feature f2 = FeatureUtils.getFeatureAfter(position, features);
        double d1 = f1 == null ? Double.MAX_VALUE : Math.abs(position - (double)f1.getEnd());
        double d2 = f2 == null ? Double.MAX_VALUE : Math.abs((double)f2.getStart() - position);
        return d1 < d2 ? f1 : f2;
    }

    private static Feature getFeatureAt(double position, List<? extends Feature> features) {
        int strt = (int)position;
        BasicFeature key = new BasicFeature("", strt, strt + 1);
        int r = Collections.binarySearch(features, key, FEATURE_START_COMPARATOR);
        if (r >= 0) {
            return features.get(r);
        }
        return null;
    }

    public static int getIndexBefore(double position, List<? extends Feature> features) {
        int idx;
        if (features == null || features.size() == 0) {
            return -1;
        }
        if ((double)features.get(features.size() - 1).getStart() <= position) {
            return features.size() - 1;
        }
        if ((double)features.get(0).getStart() >= position) {
            return 0;
        }
        int startIdx = 0;
        int endIdx = features.size() - 1;
        while (startIdx != endIdx) {
            idx = (startIdx + endIdx) / 2;
            double distance = (double)features.get(idx).getStart() - position;
            if (distance <= 0.0) {
                startIdx = idx;
            } else {
                endIdx = idx;
            }
            if (endIdx - startIdx >= 10) continue;
            break;
        }
        if ((double)features.get(endIdx).getStart() >= position) {
            for (idx = endIdx; idx >= 0; --idx) {
                if (!((double)features.get(idx).getStart() < position)) continue;
                return idx;
            }
        } else {
            for (idx = endIdx + 1; idx < features.size(); ++idx) {
                if (!((double)features.get(idx).getStart() >= position)) continue;
                return idx - 1;
            }
        }
        return -1;
    }

    public static List<Feature> getAllFeaturesAt(double position, double maxLength, double minWidth, List<? extends Feature> features) {
        int startIdx;
        Feature feature;
        int start;
        ArrayList<Feature> returnList = null;
        double adjustedPosition = Math.max(0.0, position - maxLength);
        for (int idx = startIdx = Math.max(0, FeatureUtils.getIndexBefore(adjustedPosition, features)); idx < features.size() && !((double)(start = (feature = features.get(idx)).getStart() - (int)(minWidth / 2.0)) > position); ++idx) {
            int end = feature.getEnd() + (int)(minWidth / 2.0);
            if (!(position >= (double)start) || !(position <= (double)end)) continue;
            if (returnList == null) {
                returnList = new ArrayList<Feature>();
            }
            returnList.add(feature);
        }
        return returnList;
    }

    public static void exportEDX(IGVFeature feature) {
        Genome genome = GenomeManager.getInstance().getCurrentGenome();
        System.out.println(feature.getName());
        System.out.print(genome.getId() + "\t");
        String str = feature.getStrand() == Strand.POSITIVE ? "+" : "-";
        System.out.print(feature.getChr() + "\t" + str + "\t" + feature.getStart() + "\t" + feature.getEnd() + "\t");
        List<Exon> exons = feature.getExons();
        int cdStart = 0;
        int cdEnd = 0;
        for (Exon ex : exons) {
            if (ex.getCdStart() <= ex.getStart()) continue;
            cdStart = ex.getCdStart();
            break;
        }
        for (int i = 0; i < exons.size(); ++i) {
            Exon ex;
            ex = exons.get(i);
            if (ex.getCdEnd() >= ex.getEnd()) continue;
            cdEnd = ex.getCdEnd();
            break;
        }
        System.out.println(cdStart + "\t" + cdEnd);
        System.out.println(exons.size());
        for (Exon ex : exons) {
            int rs = ex.getReadingFrame();
            int fs = rs == 0 ? 0 : 3 - rs;
            System.out.println(ex.getStart() + "\t" + ex.getEnd() + "\t" + fs);
        }
        int buffer = 10;
        for (int i = 0; i < exons.size(); ++i) {
            Exon ex = exons.get(i);
            int seqStart = ex.getStart() - buffer;
            int nextExonStart = i < exons.size() - 1 ? exons.get(i + 1).getStart() : Integer.MAX_VALUE;
            buffer = Math.min(50, (nextExonStart - ex.getEnd()) / 2);
            int seqEnd = ex.getEnd() + buffer;
            byte[] sequence = genome.getSequence(feature.getChr(), seqStart, seqEnd);
            String seqString = new String(sequence);
            System.out.println(seqStart + "\t" + seqEnd + "\t" + seqString);
        }
    }
}

