/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.dev.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.broad.igv.dev.db.DBManager;
import org.broad.igv.dev.db.DBProfile;
import org.broad.igv.util.ResourceLocator;

public class DBReader {
    private static Logger log = Logger.getLogger(DBReader.class);
    protected ResourceLocator locator;
    protected String baseQueryString;
    private String tableName;

    public static String buildBaseQueryString(String tableName, Map<Integer, String> columnLabelMap) {
        String colListing = "*";
        if (columnLabelMap != null) {
            Object[] colNames = new String[columnLabelMap.size()];
            for (Map.Entry<Integer, String> entry : columnLabelMap.entrySet()) {
                colNames[entry.getKey().intValue()] = entry.getValue();
            }
            colListing = StringUtils.join(colNames, ',');
        }
        return String.format("SELECT %s FROM %s", colListing, tableName);
    }

    public DBReader(DBProfile.DBTable table) {
        this(table.getDbLocator(), table.getName(), table.getBaseQuery());
    }

    public DBReader(ResourceLocator locator, String tableName, String baseQueryString) {
        this.locator = locator;
        assert (tableName != null);
        this.tableName = tableName;
        this.baseQueryString = baseQueryString;
        if (baseQueryString == null) {
            this.baseQueryString = DBReader.buildBaseQueryString(this.tableName, null);
        }
    }

    protected ResultSet executeQuery(String queryString) {
        try {
            Connection conn = DBManager.getConnection(this.locator);
            Statement st = conn.createStatement();
            ResultSet rs = st.executeQuery(queryString);
            return rs;
        }
        catch (SQLException e) {
            log.error("Database error", e);
            throw new RuntimeException("Database error", e);
        }
    }

    public String getTableName() {
        return this.tableName;
    }
}

