/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data.cufflinks;

import org.broad.igv.data.cufflinks.CufflinksValue;
import org.broad.igv.track.WindowFunction;

public class FPKMValue
extends CufflinksValue {
    float fpkm;
    float fpkmLo;
    float fpkmHi;

    public FPKMValue(String gene, String chr, int start, int end, float fpkm, float fpkmLo, float fpkmHi) {
        super(gene, chr, start, end);
        this.fpkm = fpkm;
        this.fpkmLo = fpkmLo;
        this.fpkmHi = fpkmHi;
    }

    @Override
    public float getScore() {
        return this.fpkm;
    }

    @Override
    public String getValueString(double position, WindowFunction windowFunction) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getChr() + ":" + (this.getStart() + 1) + "-" + this.getEnd());
        sb.append("<br>Gene = " + this.gene);
        sb.append("<br>FPKM = " + this.fpkm);
        sb.append("<br>FPKM_LO = " + this.fpkmLo);
        sb.append("<br>FPKM_HI = " + this.fpkmHi);
        return sb.toString();
    }

    @Override
    public String getGene() {
        return this.gene;
    }
}

