/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.cli_plugin.ui;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.awt.Component;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import org.broad.igv.cli_plugin.Argument;
import org.broad.igv.cli_plugin.ui.ArgumentPanel;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.track.DataTrack;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.track.Track;
import org.broad.igv.ui.IGV;

public class TrackArgument
extends ArgumentPanel {
    private JComboBox trackComboBox;

    public TrackArgument(Argument argument) {
        this.initComponents();
        super.initCommon(argument);
        if (argument != null) {
            List<Track> trackList = IGV.getInstance().getAllTracks();
            Class clazz = this.getTrackClass(argument);
            Iterable tracks = Iterables.filter(trackList, clazz);
            this.trackComboBox.setModel(new DefaultComboBoxModel<Object>(Lists.newArrayList(tracks).toArray()));
            this.trackComboBox.setRenderer(new TrackComboBoxRenderer());
        }
    }

    private void initComponents() {
        this.trackComboBox = new JComboBox();
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.trackComboBox);
    }

    @Override
    public Track getValue() {
        return (Track)this.trackComboBox.getSelectedItem();
    }

    public Class getTrackClass(Argument argument) {
        switch (argument.getType()) {
            case FEATURE_TRACK: {
                return FeatureTrack.class;
            }
            case ALIGNMENT_TRACK: {
                return AlignmentTrack.class;
            }
            case DATA_TRACK: {
                return DataTrack.class;
            }
        }
        throw new IllegalArgumentException("Argument does not specify a track type; specifies " + (Object)((Object)argument.getType()));
    }

    public static class TrackComboBoxRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Track track = (Track)value;
            String toShow = track.getName();
            return super.getListCellRendererComponent((JList<?>)list, toShow, index, isSelected, cellHasFocus);
        }
    }
}

