/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.cli_plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlList;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.log4j.Logger;
import org.broad.igv.cli_plugin.Argument;
import org.broad.igv.cli_plugin.AsciiDecoder;
import org.broad.igv.cli_plugin.AsciiEncoder;
import org.broad.igv.cli_plugin.FeatureDecoder;
import org.broad.igv.cli_plugin.FeatureEncoder;
import org.broad.igv.cli_plugin.LineFeatureDecoder;
import org.broad.igv.cli_plugin.LineFeatureEncoder;
import org.broad.igv.cli_plugin.PluginSpecReader;
import org.broad.igv.cli_plugin.SamAlignmentEncoder;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.feature.tribble.CodecFactory;
import org.broad.igv.feature.tribble.IGVBEDCodec;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.session.IGVSessionReader;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.track.Track;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.RuntimeUtils;
import org.broad.tribble.AsciiFeatureCodec;
import org.broad.tribble.Feature;

@XmlAccessorType(value=XmlAccessType.NONE)
public abstract class PluginSource<E extends Feature, D extends Feature> {
    private static Logger log = Logger.getLogger(PluginSource.class);
    @XmlList
    @XmlAttribute
    protected List<String> commands;
    @XmlJavaTypeAdapter(value=MyMapAdapter.class)
    protected LinkedHashMap<Argument, Object> arguments;
    @XmlElement
    protected PluginSpecReader.Parser parser;
    protected URL[] decodingLibURLs = new URL[0];
    @XmlAttribute
    protected String specPath = null;
    protected List<Map<String, Object>> attributes = new ArrayList<Map<String, Object>>(2);

    protected PluginSource() {
    }

    public PluginSource(List<String> commands, LinkedHashMap<Argument, Object> arguments, PluginSpecReader.Parser parsingAttrs, String specPath) {
        this.commands = commands;
        this.arguments = arguments;
        this.parser = parsingAttrs;
        this.specPath = specPath;
        String[] libs = parsingAttrs.libs;
        libs = libs != null ? libs : new String[]{};
        try {
            this.decodingLibURLs = PluginSpecReader.getLibURLs(libs, FileUtils.getParent(specPath));
        }
        catch (MalformedURLException e) {
            log.error("Error parsing library URL", e);
            throw new RuntimeException(e);
        }
    }

    protected final Map<String, Object> writeFeaturesToStream(OutputStream outputStream, Iterator<E> features, Argument argument) throws IOException {
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(outputStream));
        Map<String, Object> attributes = null;
        if (features != null) {
            FeatureEncoder<E> codec = this.getEncodingCodec(argument);
            attributes = codec.encodeAll(outputStream, features);
        }
        writer.flush();
        writer.close();
        return attributes;
    }

    protected final String[] genFullCommand(String chr, int start, int end, int zoom) throws IOException {
        ArrayList<String> fullCmd = new ArrayList<String>(this.commands);
        this.attributes.clear();
        HashMap<String, String[]> argValsById = new HashMap<String, String[]>(this.arguments.size());
        block7: for (Map.Entry<Argument, Object> entry : this.arguments.entrySet()) {
            Argument arg = entry.getKey();
            assert (arg.isValidValue(entry.getValue()));
            String[] sVal = null;
            String ts = null;
            switch (arg.getType()) {
                case BOOL: {
                    boolean selected = (Boolean)entry.getValue();
                    if (!selected) continue block7;
                    break;
                }
                case LONGTEXT: 
                case TEXT: {
                    ts = (String)entry.getValue();
                    if (ts == null || ts.trim().length() == 0) continue block7;
                    sVal = new String[]{ts};
                    if (arg.getType() != Argument.InputType.TEXT) break;
                    sVal = ts.split("\\s+");
                    break;
                }
                case ALIGNMENT_TRACK: {
                    ts = this.createTempFile((AlignmentTrack)entry.getValue(), arg, chr, start, end, zoom);
                    sVal = new String[]{ts};
                    break;
                }
                case FEATURE_TRACK: 
                case DATA_TRACK: {
                    ts = this.createTempFile((Track)entry.getValue(), arg, chr, start, end, zoom);
                    sVal = new String[]{ts};
                    break;
                }
                case MULTI_FEATURE_TRACK: {
                    sVal = this.createTempFiles((List)entry.getValue(), arg, chr, start, end, zoom);
                }
            }
            if (arg.getId() != null) {
                argValsById.put(arg.getId(), sVal);
            }
            if (!arg.isOutput()) continue;
            String cmdArg = arg.getCmdArg();
            if (cmdArg.trim().length() > 0) {
                for (String argId : argValsById.keySet()) {
                    cmdArg = cmdArg.replace("$" + argId, ((String[])argValsById.get(argId))[0]);
                }
                fullCmd.add(cmdArg);
            }
            if (sVal == null) continue;
            fullCmd.addAll(Arrays.asList(sVal));
        }
        for (String argId : argValsById.keySet()) {
            String repStr = "$" + argId;
            this.parser.source = this.parser.source.replace(repStr, ((String[])argValsById.get(argId))[0]);
        }
        return fullCmd.toArray(new String[0]);
    }

    private String[] createTempFiles(List<FeatureTrack> tracks, Argument argument, String chr, int start, int end, int zoom) throws IOException {
        String[] fileNames = new String[tracks.size()];
        int fi = 0;
        for (FeatureTrack track : tracks) {
            fileNames[fi++] = this.createTempFile(track, argument, chr, start, end, zoom);
        }
        return fileNames;
    }

    protected abstract String createTempFile(Track var1, Argument var2, String var3, int var4, int var5, int var6) throws IOException;

    protected final String createTempFile(List<E> features, Argument argument) throws IOException {
        File outFile = File.createTempFile("features", ".tmp", null);
        outFile.deleteOnExit();
        Map<String, Object> attributes = this.writeFeaturesToStream(new FileOutputStream(outFile), features.iterator(), argument);
        String path = outFile.getAbsolutePath();
        this.attributes.add(attributes);
        return path;
    }

    protected final Iterator<D> getFeatures(String chr, int start, int end, int zoom) throws IOException {
        String[] fullCmd = this.genFullCommand(chr, start, end, zoom);
        Process pr = RuntimeUtils.startExternalProcess(fullCmd, null, null);
        FeatureDecoder<D> codec = this.getDecodingCodec();
        InputStream dataStream = null;
        if (this.parser.source.equals(PluginSpecReader.Parser.SOURCE_STDOUT)) {
            dataStream = pr.getInputStream();
        } else {
            if (this.parser.source == null) {
                throw new IllegalArgumentException("Null value for source");
            }
            try {
                pr.waitFor();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            dataStream = new FileInputStream(this.parser.source);
        }
        return codec.decodeAll(dataStream, this.parser.strict);
    }

    protected final FeatureEncoder<E> getEncodingCodec(Argument argument) {
        FeatureEncoder codec = this.instantiateEncodingCodec(argument);
        codec.setInputs(Collections.unmodifiableList(this.commands), Collections.unmodifiableMap(this.arguments));
        return codec;
    }

    private final FeatureEncoder instantiateEncodingCodec(Argument argument) {
        String encodingCodec = argument.getEncodingCodec();
        if (encodingCodec == null) {
            if (argument.getType() == Argument.InputType.FEATURE_TRACK || argument.getType() == Argument.InputType.MULTI_FEATURE_TRACK) {
                return new AsciiEncoder<Feature>(new IGVBEDCodec());
            }
            if (argument.getType() == Argument.InputType.ALIGNMENT_TRACK) {
                return new SamAlignmentEncoder();
            }
            throw new IllegalArgumentException("No encoding codec provided and default not available");
        }
        try {
            URLClassLoader loader;
            Class<?> clazz;
            Constructor<?> constructor;
            Object ocodec;
            URL[] libURLs = PluginSpecReader.getLibURLs(argument.getLibPaths(), FileUtils.getParent(this.specPath));
            if (libURLs == null) {
                libURLs = new URL[]{};
            }
            AsciiEncoder codec = !((ocodec = (constructor = (clazz = (loader = URLClassLoader.newInstance(libURLs, this.getClass().getClassLoader())).loadClass(encodingCodec)).getConstructor(new Class[0])).newInstance(new Object[0])) instanceof FeatureEncoder) && ocodec instanceof LineFeatureEncoder ? new AsciiEncoder((LineFeatureEncoder)ocodec) : (AsciiEncoder)ocodec;
            return codec;
        }
        catch (ClassNotFoundException e) {
            log.error("Could not find class " + encodingCodec, e);
            throw new IllegalArgumentException(e);
        }
        catch (MalformedURLException e) {
            log.error("Malformed library URL", e);
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            log.error("Exception getting encoding codec", e);
            throw new RuntimeException(e);
        }
    }

    protected final FeatureDecoder<D> getDecodingCodec() {
        FeatureDecoder<D> codec = this.instantiateDecodingCodec(this.parser.decodingCodec, this.decodingLibURLs);
        codec.setInputs(Collections.unmodifiableList(this.commands), Collections.unmodifiableMap(this.arguments));
        codec.setAttributes(Collections.unmodifiableList(this.attributes));
        return codec;
    }

    protected final FeatureDecoder<D> instantiateDecodingCodec(String decodingCodec, URL[] libURLs) {
        if (decodingCodec == null) {
            AsciiFeatureCodec asciiCodec = CodecFactory.getCodec("." + this.parser.format, GenomeManager.getInstance().getCurrentGenome());
            if (asciiCodec == null) {
                throw new IllegalArgumentException("Unable to find codec for format " + this.parser.format);
            }
            return new AsciiDecoder.DecoderWrapper(asciiCodec);
        }
        try {
            URLClassLoader loader;
            Class<?> clazz;
            Constructor<?> constructor;
            Object codec;
            if (libURLs == null) {
                libURLs = new URL[]{};
            }
            if (!((codec = (constructor = (clazz = (loader = URLClassLoader.newInstance(libURLs, this.getClass().getClassLoader())).loadClass(decodingCodec)).getConstructor(new Class[0])).newInstance(new Object[0])) instanceof FeatureDecoder) && codec instanceof LineFeatureDecoder) {
                return new AsciiDecoder((LineFeatureDecoder)codec);
            }
            return (FeatureDecoder)codec;
        }
        catch (ClassNotFoundException e) {
            log.error("Could not find class " + decodingCodec, e);
            throw new IllegalArgumentException(e);
        }
        catch (Exception e) {
            log.error("Exception getting decoding codec", e);
            throw new RuntimeException(e);
        }
    }

    public void getPersistentState() {
    }

    public void updateTrackReferences(List<Track> allTracks) {
        MyMapAdapter.updateTrackReferences(this.arguments, allTracks);
    }

    public static final class MyMapAdapter
    extends XmlAdapter<XmlMap, LinkedHashMap<Argument, Object>> {
        public static WeakReference<IGVSessionReader> sessionReader;

        public static void setSessionReader(IGVSessionReader igvSessionReader) {
            sessionReader = new WeakReference<IGVSessionReader>(igvSessionReader);
        }

        public LinkedHashMap<Argument, Object> unmarshal(XmlMap v) throws Exception {
            LinkedHashMap<Argument, Object> argumentMap = new LinkedHashMap<Argument, Object>(v.arg.size());
            for (Argument argument : v.arg) {
                Object oVal = null;
                switch (argument.getType()) {
                    case LONGTEXT: 
                    case TEXT: {
                        oVal = argument.value.get(0);
                        break;
                    }
                    case ALIGNMENT_TRACK: 
                    case FEATURE_TRACK: 
                    case DATA_TRACK: 
                    case MULTI_FEATURE_TRACK: {
                        oVal = MyMapAdapter.findTrackReference(argument, null);
                    }
                }
                argumentMap.put(argument, oVal);
            }
            return argumentMap;
        }

        private static Track getMatchingTrack(String trackId, List<Track> allTracks) {
            List<Track> matchingTracks;
            IGVSessionReader reader = (IGVSessionReader)sessionReader.get();
            if (reader != null) {
                matchingTracks = reader.getTracksById(trackId);
            } else {
                if (allTracks == null) {
                    throw new IllegalStateException("No session reader and no tracks to search to resolve Track references");
                }
                matchingTracks = new ArrayList<Track>();
                for (Track track : allTracks) {
                    if (!trackId.equals(track.getId())) continue;
                    matchingTracks.add(track);
                    break;
                }
            }
            if (matchingTracks == null || matchingTracks.size() == 0) {
                return null;
            }
            if (matchingTracks.size() >= 2) {
                log.debug("Found multiple tracks with id  " + trackId + ", using the first");
            }
            return matchingTracks.get(0);
        }

        private static Object findTrackReference(Argument argument, List<Track> allTracks) {
            Object oVal = null;
            switch (argument.getType()) {
                case MULTI_FEATURE_TRACK: {
                    ArrayList<FeatureTrack> inputTracks = new ArrayList<FeatureTrack>(argument.value.size());
                    for (String trackId : argument.value) {
                        inputTracks.add((FeatureTrack)MyMapAdapter.getMatchingTrack(trackId, allTracks));
                    }
                    oVal = inputTracks;
                    break;
                }
                case ALIGNMENT_TRACK: 
                case FEATURE_TRACK: 
                case DATA_TRACK: {
                    String trackId = argument.value.get(0);
                    oVal = MyMapAdapter.getMatchingTrack(trackId, allTracks);
                }
            }
            return oVal;
        }

        public static void updateTrackReferences(Map<Argument, Object> argumentMap, List<Track> allTracks) {
            for (Argument argument : argumentMap.keySet()) {
                if (argumentMap.get(argument) != null) continue;
                Object oVal = MyMapAdapter.findTrackReference(argument, allTracks);
                argumentMap.put(argument, oVal);
            }
        }

        public XmlMap marshal(LinkedHashMap<Argument, Object> v) throws Exception {
            XmlMap outMap = new XmlMap();
            for (Map.Entry<Argument, Object> loopEntry : v.entrySet()) {
                Argument argument = loopEntry.getKey();
                List<Object> values = null;
                switch (argument.getType()) {
                    case MULTI_FEATURE_TRACK: {
                        List lVal = (List)loopEntry.getValue();
                        values = new ArrayList(lVal.size());
                        for (FeatureTrack fTrack : lVal) {
                            values.add(fTrack.getId());
                        }
                        break;
                    }
                    case LONGTEXT: 
                    case TEXT: {
                        String sval = (String)loopEntry.getValue();
                        values = Arrays.asList(sval);
                        break;
                    }
                    case ALIGNMENT_TRACK: 
                    case FEATURE_TRACK: 
                    case DATA_TRACK: {
                        String sval = ((Track)loopEntry.getValue()).getId();
                        values = Arrays.asList(sval);
                    }
                }
                argument.value = values;
                outMap.arg.add(argument);
            }
            return outMap;
        }
    }

    static class XmlMap {
        public List<Argument> arg = new ArrayList<Argument>();

        XmlMap() {
        }
    }
}

