/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.cli_plugin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.cli_plugin.Argument;
import org.broad.igv.cli_plugin.PluginSource;
import org.broad.igv.cli_plugin.PluginSpecReader;
import org.broad.igv.data.DataSource;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.track.DataTrack;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackType;
import org.broad.igv.track.WindowFunction;

public class PluginDataSource
extends PluginSource<LocusScore, LocusScore>
implements DataSource {
    private static Logger log = Logger.getLogger(PluginDataSource.class);
    private double dataMin;
    private double dataMax;
    private WindowFunction windowFunction;

    public PluginDataSource(List<String> commands, LinkedHashMap<Argument, Object> arguments, PluginSpecReader.Parser parsingAttrs, String specPath) {
        super(commands, arguments, parsingAttrs, specPath);
    }

    @Override
    protected String createTempFile(Track track, Argument argument, String chr, int start, int end, int zoom) throws IOException {
        DataTrack dataTrack = (DataTrack)track;
        List<LocusScore> features = dataTrack.getSummaryScores(chr, start, end, zoom);
        return super.createTempFile(features, argument);
    }

    @Override
    public List<LocusScore> getSummaryScoresForRange(String chr, int startLocation, int endLocation, int zoom) {
        try {
            Iterator iter = super.getFeatures(chr, startLocation, endLocation, zoom);
            ArrayList<LocusScore> list = new ArrayList<LocusScore>(1000);
            this.dataMin = Double.MAX_VALUE;
            this.dataMax = -1.7976931348623157E308;
            while (iter.hasNext()) {
                LocusScore score = (LocusScore)iter.next();
                this.dataMin = Math.min(this.dataMin, (double)score.getScore());
                this.dataMax = Math.max(this.dataMax, (double)score.getScore());
                list.add(score);
            }
            return list;
        }
        catch (IOException e) {
            log.error(e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public double getDataMax() {
        return this.dataMax;
    }

    @Override
    public double getDataMin() {
        return this.dataMin;
    }

    @Override
    public TrackType getTrackType() {
        return TrackType.PLUGIN;
    }

    @Override
    public void setWindowFunction(WindowFunction statType) {
        this.windowFunction = statType;
    }

    @Override
    public WindowFunction getWindowFunction() {
        return this.windowFunction;
    }

    @Override
    public boolean isLogNormalized() {
        return false;
    }

    @Override
    public Collection<WindowFunction> getAvailableWindowFunctions() {
        return null;
    }
}

