/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.cli_plugin;

import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import org.apache.log4j.Logger;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.track.FeatureTrack;

@XmlAccessorType(value=XmlAccessType.NONE)
public class Argument {
    public static final String CMD_ARG = "cmd_arg";
    public static final String LIBS = "libs";
    private static final Logger log = Logger.getLogger(Argument.class);
    @XmlAttribute
    private String name;
    @XmlAttribute
    private InputType type;
    @XmlAttribute(name="cmd_arg")
    private String cmdArg;
    @XmlAttribute(name="default")
    private String defaultValue;
    @XmlAttribute
    private boolean output = false;
    @XmlAttribute
    private String id;
    @XmlAttribute
    private String encodingCodec;
    @XmlElement(name="libs")
    private String[] libPaths;
    @XmlElement
    List<String> value;

    boolean isValidValue(Object value) {
        switch (this.type) {
            case BOOL: {
                return value instanceof Boolean;
            }
            case TEXT: 
            case LONGTEXT: {
                return value instanceof String || value == null;
            }
            case ALIGNMENT_TRACK: {
                return value instanceof AlignmentTrack;
            }
            case FEATURE_TRACK: {
                return value instanceof FeatureTrack;
            }
            case MULTI_FEATURE_TRACK: {
                if (!(value instanceof List)) {
                    return false;
                }
                try {
                    List lVal = (List)value;
                    FeatureTrack fVal = (FeatureTrack)lVal.get(0);
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public String getCmdArg() {
        return this.cmdArg;
    }

    public InputType getType() {
        return this.type;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String[] getLibPaths() {
        return this.libPaths;
    }

    public boolean isOutput() {
        return this.output;
    }

    public void setOutput(boolean output) {
        this.output = output;
    }

    public String getId() {
        return this.id;
    }

    public String getEncodingCodec() {
        return this.encodingCodec;
    }

    private Argument() {
    }

    Argument(String name, InputType type, String cmdArg, String defaultValue, String encodingCodec, String[] libPaths, boolean isOutput, String id) {
        this.name = name;
        this.type = type;
        this.cmdArg = cmdArg != null ? cmdArg : "";
        this.defaultValue = defaultValue;
        this.encodingCodec = encodingCodec;
        this.libPaths = libPaths;
        this.output = isOutput;
        this.id = id;
        if (!this.output && id == null) {
            log.info(String.format("Argument %s is not output but it also has no id. This argument will have no effect", name));
        }
    }

    @XmlEnum
    public static enum InputType {
        BOOL,
        TEXT,
        LONGTEXT,
        FEATURE_TRACK,
        DATA_TRACK,
        MULTI_FEATURE_TRACK,
        ALIGNMENT_TRACK;

    }
}

