/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bbfile;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import net.sf.samtools.seekablestream.SeekableStream;
import org.apache.log4j.Logger;
import org.broad.igv.bbfile.BigWigSection;
import org.broad.igv.bbfile.RPChromosomeRegion;
import org.broad.igv.bbfile.RPTreeLeafNodeItem;
import org.broad.igv.bbfile.WigItem;
import org.broad.igv.util.CompressionUtils;

public class BigWigDataBlock {
    private static Logger log = Logger.getLogger(BigWigDataBlock.class);
    final int FIXED_STEP_ITEM_SIZE = 4;
    final int VAR_STEP_ITEM_SIZE = 8;
    final int BED_GRAPH_ITEM_SIZE = 12;
    private long fileOffset;
    private long leafDataSize;
    private boolean isLowToHigh;
    private HashMap<Integer, String> chromosomeMap;
    private RPTreeLeafNodeItem leafHitItem;
    private byte[] wigBuffer;
    private int remDataSize;
    private ArrayList<WigItem> wigItemList;

    public BigWigDataBlock(SeekableStream fis, RPTreeLeafNodeItem leafHitItem, HashMap<Integer, String> chromosomeMap, boolean isLowToHigh, int uncompressBufSize, CompressionUtils compressionUtils) {
        this.leafHitItem = leafHitItem;
        this.chromosomeMap = chromosomeMap;
        this.isLowToHigh = isLowToHigh;
        this.fileOffset = this.leafHitItem.getDataOffset();
        this.leafDataSize = this.leafHitItem.geDataSize();
        byte[] buffer = new byte[(int)this.leafDataSize];
        try {
            fis.seek(this.fileOffset);
            fis.readFully(buffer);
            this.wigBuffer = uncompressBufSize > 0 ? compressionUtils.decompress(buffer, uncompressBufSize) : buffer;
        }
        catch (IOException ex) {
            log.error("Error reading Wig section for leaf item ", ex);
            String error = String.format("Error reading Wig section for leaf item %d\n", new Object[0]);
            throw new RuntimeException(error, ex);
        }
        this.remDataSize = this.wigBuffer.length;
    }

    public ArrayList<WigItem> getWigData(RPChromosomeRegion selectionRegion, boolean contained) {
        this.wigItemList = new ArrayList();
        int index = 0;
        while (this.remDataSize > 0) {
            BigWigSection wigSection = new BigWigSection(this.wigBuffer, this.chromosomeMap, this.isLowToHigh, this.leafHitItem);
            int sectionBytes = wigSection.getSectionData(selectionRegion, contained, this.wigItemList);
            this.remDataSize -= sectionBytes;
            ++index;
        }
        return this.wigItemList;
    }

    public void print() {
        log.debug("Wig section data referenced by leaf item ");
        for (int index = 0; index <= this.wigItemList.size(); ++index) {
            this.wigItemList.get(index).print();
        }
    }
}

