/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.apt;

import com.google.java.contract.Invariant;
import com.google.java.contract.Requires;
import com.google.java.contract.core.apt.FactoryUtils;
import com.google.java.contract.core.model.ElementModifier;
import com.google.java.contract.core.model.TypeModel;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.ElementScanner6;

@Invariant(value={"subtype != null"})
class SuperCallBuilder
extends ElementScanner6<Void, Void> {
    protected FactoryUtils utils;
    protected DeclaredType typeMirror;
    protected TypeModel subtype;
    protected ElementModifier constructorFound;

    @Requires(value={"subtype != null", "utils != null"})
    SuperCallBuilder(DeclaredType declaredType, TypeModel typeModel, FactoryUtils factoryUtils) {
        this.utils = factoryUtils;
        this.typeMirror = declaredType;
        this.subtype = typeModel;
        this.constructorFound = null;
    }

    @Override
    public Void visitType(TypeElement typeElement, Void void_) {
        this.scan(ElementFilter.constructorsIn(typeElement.getEnclosedElements()), null);
        return null;
    }

    @Override
    public Void visitExecutable(ExecutableElement executableElement, Void void_) {
        ElementModifier elementModifier = ElementModifier.visibilityIn(ElementModifier.forModifiers(executableElement.getModifiers()));
        if (this.constructorFound != null && this.constructorFound.ordinal() <= elementModifier.ordinal()) {
            return null;
        }
        this.subtype.clearSuperArguments();
        ExecutableType executableType = (ExecutableType)this.utils.typeUtils.asMemberOf(this.typeMirror, executableElement);
        List<? extends TypeMirror> list = executableType.getParameterTypes();
        for (TypeMirror typeMirror : list) {
            this.subtype.addSuperArgument(this.utils.getTypeNameForType(typeMirror));
        }
        this.constructorFound = elementModifier;
        return null;
    }
}

