/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util.stream;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import net.sf.samtools.seekablestream.SeekableFileStream;
import net.sf.samtools.seekablestream.SeekableHTTPStream;
import net.sf.samtools.seekablestream.SeekableStream;
import org.broad.igv.util.HttpUtils;
import org.broad.igv.util.stream.IGVSeekableFTPStream;
import org.broad.igv.util.stream.SeekableServiceStream;
import org.broad.igv.util.stream.SeekableSplitStream;

public class IGVSeekableStreamFactory {
    public static SeekableStream getStreamFor(String path) throws IOException {
        if (path.endsWith(".list")) {
            return new SeekableSplitStream(path);
        }
        SeekableStream is = null;
        if (path.toLowerCase().startsWith("http:") || path.toLowerCase().startsWith("https:")) {
            URL url = new URL(path);
            boolean useByteRange = HttpUtils.getInstance().useByteRange(url);
            is = useByteRange ? new SeekableHTTPStream(url) : new SeekableServiceStream(url);
        } else if (path.toLowerCase().startsWith("ftp:")) {
            URL url = new URL(path);
            is = new IGVSeekableFTPStream(url);
        } else {
            is = new SeekableFileStream(new File(path));
        }
        return is;
    }
}

