/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.action;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.broad.igv.feature.genome.GenomeListItem;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.UserDefinedGenomeCheckList;
import org.broad.igv.ui.action.MenuAction;

public class RemoveUserDefinedGenomeMenuAction
extends MenuAction {
    static Logger logger = Logger.getLogger(RemoveUserDefinedGenomeMenuAction.class);

    public RemoveUserDefinedGenomeMenuAction(String label, int mnemonic) {
        super(label, null, mnemonic);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            Collection<GenomeListItem> genomeItemList = GenomeManager.getInstance().getUserDefinedGenomeArchiveList();
            if (genomeItemList.isEmpty()) {
                JOptionPane.showMessageDialog(IGV.getMainFrame(), "There are no imported genomes to remove.");
            } else {
                GenomeListItem currentlySelectedDropdownGenome = IGV.getInstance().getGenomeSelectedInDropdown();
                ArrayList<String> genomeNames = new ArrayList<String>();
                UserDefinedGenomeCheckList checkList = new UserDefinedGenomeCheckList(false);
                for (GenomeListItem genomeListItem : genomeItemList) {
                    genomeNames.add(genomeListItem.getDisplayableName());
                }
                checkList.addItems(genomeNames);
                checkList.sort();
                int status = JOptionPane.showConfirmDialog(IGV.getMainFrame(), checkList, "Imported Genomes to Remove", 2, -1, null);
                if (status == 2 || status == -1) {
                    return;
                }
                boolean removed = false;
                HashSet<String> selectedGenomes = checkList.getSelectedGenomes();
                Iterator<GenomeListItem> iterator = genomeItemList.iterator();
                while (iterator.hasNext()) {
                    String genomeName = iterator.next().getDisplayableName();
                    if (!selectedGenomes.contains(genomeName)) continue;
                    if (currentlySelectedDropdownGenome.getDisplayableName().equalsIgnoreCase(genomeName)) {
                        JOptionPane.showMessageDialog(IGV.getMainFrame(), "<html>Genome [" + genomeName + "] is currently in use and cannot be removed." + "<br>Please select another genome to view before trying to remove it.</html>");
                        continue;
                    }
                    if (!selectedGenomes.contains(genomeName)) continue;
                    iterator.remove();
                    removed = true;
                }
                if (removed) {
                    GenomeManager.getInstance().updateImportedGenomePropertyFile();
                    IGV.getInstance().rebuildGenomeDropdownList();
                }
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(IGV.getMainFrame(), "Error encontered while removing genomes: " + ex.getMessage());
            logger.error("Error removing genomes from the imported genome list.", ex);
        }
    }
}

