/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui;

import java.awt.Font;
import java.util.Hashtable;
import org.broad.igv.PreferenceManager;

public class FontManager {
    private static Font defaultFont;
    static Hashtable<String, Font> fontCache;

    public static Font getDefaultFont() {
        if (defaultFont == null) {
            FontManager.updateDefaultFont();
        }
        return defaultFont;
    }

    public static Font getFont(int size) {
        PreferenceManager prefManager = PreferenceManager.getInstance();
        String fontFamily = prefManager.get("DEFAULT_FONT_FAMILY");
        int attribute = prefManager.getAsInt("DEFAULT_FONT_ATTRIBUTE");
        String key = fontFamily + "_" + attribute + "_" + size;
        Font font = fontCache.get(key);
        if (font == null) {
            font = new Font(fontFamily, attribute, size);
            fontCache.put(key, font);
        }
        return font;
    }

    public static Font getFont(int attribute, int size) {
        PreferenceManager prefManager = PreferenceManager.getInstance();
        String fontFamily = prefManager.get("DEFAULT_FONT_FAMILY");
        String key = fontFamily + "_" + attribute + "_" + size;
        Font font = fontCache.get(key);
        if (font == null) {
            font = new Font(fontFamily, attribute, size);
            fontCache.put(key, font);
        }
        return font;
    }

    public static void updateDefaultFont() {
        PreferenceManager prefManager = PreferenceManager.getInstance();
        String fontFamily = prefManager.get("DEFAULT_FONT_FAMILY");
        int fontSize = prefManager.getAsInt("DEFAULT_FONT_SIZE");
        int attribute = prefManager.getAsInt("DEFAULT_FONT_ATTRIBUTE");
        defaultFont = new Font(fontFamily, attribute, fontSize);
    }

    static {
        fontCache = new Hashtable();
    }
}

