/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.apache.log4j.Logger;
import org.broad.igv.feature.AbstractFeature;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.Exon;
import org.broad.igv.feature.FeatureUtils;
import org.broad.igv.feature.IGVFeature;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.WrappedIterator;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.tribble.GFFCodec;
import org.broad.igv.track.TribbleFeatureSource;
import org.broad.igv.util.collections.MultiMap;
import org.broad.tribble.CloseableTribbleIterator;
import org.broad.tribble.Feature;

public class GFFFeatureSource
extends TribbleFeatureSource {
    private static Logger log = Logger.getLogger(GFFFeatureSource.class);
    public static final String PHASE_STRING = "XXPHASE_STRINGXX";

    public static boolean isGFF(String path) {
        int idx;
        String lowpath = path.toLowerCase();
        if (lowpath.endsWith(".gz")) {
            idx = lowpath.length() - 3;
            lowpath = lowpath.substring(0, idx);
        }
        if (lowpath.endsWith(".txt")) {
            idx = lowpath.length() - 4;
            lowpath = lowpath.substring(0, idx);
        }
        return lowpath.endsWith("gff3") || lowpath.endsWith("gvf") || lowpath.endsWith("gff") || lowpath.endsWith("gtf");
    }

    public GFFFeatureSource(String path, Genome genome) throws IOException {
        super(path, genome);
        this.isVCF = false;
    }

    @Override
    public CloseableTribbleIterator<Feature> getFeatures(String chr, int start, int end) throws IOException {
        Iterator rawIter = super.getFeatures(chr, start, end);
        GFFCombiner combiner = new GFFCombiner().addFeatures(rawIter);
        return new WrappedIterator<Feature>(combiner.combineFeatures().iterator());
    }

    static class GFF3Transcript {
        private static final String ID_ABSENT = "SPECIALIDFOROBJECTSWITHNOID";
        private String id;
        private Set<Exon> exons = new HashSet<Exon>();
        private List<Exon> cdss = new ArrayList<Exon>();
        private Exon fivePrimeUTR;
        private Exon threePrimeUTR;
        private BasicFeature basicTranscript;
        private String parentId;
        String chr = null;
        int start = Integer.MAX_VALUE;
        int end = Integer.MIN_VALUE;
        String description;
        MultiMap<String, String> attributes;
        Map<String, BasicFeature> geneCache;

        GFF3Transcript(String id, Map<String, BasicFeature> geneCache) {
            this.id = id;
            this.geneCache = geneCache;
        }

        void setBasicTranscript(BasicFeature basicTranscript, String parent) {
            this.basicTranscript = basicTranscript;
            this.parentId = parent;
            if (basicTranscript.getName() == null) {
                basicTranscript.setName(basicTranscript.getIdentifier());
            }
            if (basicTranscript.getName() == null) {
                return;
            }
            int prefixIndex = basicTranscript.getName().indexOf(":");
            if (prefixIndex > 0) {
                basicTranscript.setName(basicTranscript.getName().substring(prefixIndex + 1));
            }
        }

        void setFivePrimeUTR(Exon exon) {
            this.fivePrimeUTR = exon;
            this.start = Math.min(exon.getStart(), this.start);
            this.end = Math.max(exon.getEnd(), this.end);
        }

        void setThreePrimeUTR(Exon exon) {
            this.threePrimeUTR = exon;
            this.start = Math.min(exon.getStart(), this.start);
            this.end = Math.max(exon.getEnd(), this.end);
        }

        void addExon(Exon exon) {
            this.exons.add(exon);
            this.start = Math.min(exon.getStart(), this.start);
            this.end = Math.max(exon.getEnd(), this.end);
        }

        void addCDS(Exon cds) {
            this.cdss.add(cds);
            this.start = Math.min(cds.getStart(), this.start);
            this.end = Math.max(cds.getEnd(), this.end);
        }

        void addCDSParts(String chr, int start, int end) {
            this.chr = chr;
            this.start = Math.min(this.start, start);
            this.end = Math.max(this.end, end);
        }

        List<? extends Feature> createTranscript() {
            HashMap<String, List<Exon>> cdsByID = new HashMap<String, List<Exon>>();
            for (Exon cds : this.cdss) {
                String cdsID = cds.getAttributes().get("ID");
                ArrayList<Exon> cdsArr = (ArrayList<Exon>)cdsByID.get(cdsID);
                if (cdsArr == null) {
                    cdsArr = new ArrayList<Exon>();
                    cdsByID.put(cdsID, cdsArr);
                }
                cdsArr.add(cds);
            }
            if (cdsByID.size() == this.cdss.size()) {
                cdsByID = new HashMap(1);
                cdsByID.put(this.id, this.cdss);
            }
            HashSet<Exon> foundExons = new HashSet<Exon>();
            ArrayList<BasicFeature> transcriptList = new ArrayList<BasicFeature>(cdsByID.size());
            for (String cdsID : cdsByID.keySet()) {
                HashSet<Exon> exonSet = new HashSet<Exon>();
                for (Exon cds : (List)cdsByID.get(cdsID)) {
                    Exon exon = this.findMatchingExon(this.exons, cds);
                    if (exon == null) {
                        cds.setCodingStart(cds.getStart());
                        cds.setCodingEnd(cds.getEnd());
                        exonSet.add(cds);
                        continue;
                    }
                    if (foundExons.contains(exon)) {
                        exon = exon.copy();
                    } else {
                        foundExons.add(exon);
                    }
                    exon.setCodingStart(cds.getStart());
                    exon.setCodingEnd(cds.getEnd());
                    exon.setReadingFrame(cds.getReadingFrame());
                    exonSet.add(exon);
                }
                for (Exon exon : this.exons) {
                    if (foundExons.contains(exon)) continue;
                    exonSet.add(exon);
                    exon.setUTR(true);
                }
                Strand strand = Strand.NONE;
                String name = null;
                String curChr = this.chr;
                int curStart = this.start;
                int curEnd = this.end;
                for (Exon exon : exonSet) {
                    curChr = exon.getChr();
                    strand = exon.getStrand();
                    curStart = Math.min(exon.getStart(), curStart);
                    curEnd = Math.max(exon.getEnd(), curEnd);
                    name = exon.getName();
                }
                BasicFeature curTranscript = this.basicTranscript;
                if (curTranscript == null) {
                    curTranscript = new BasicFeature(curChr, curStart, curEnd, strand);
                    curTranscript.setIdentifier(this.id);
                    curTranscript.setName(name == null ? this.id : name);
                    curTranscript.setDescription(this.description);
                    curTranscript.setAttributes(this.attributes);
                } else if (cdsByID.size() >= 2) {
                    curTranscript = this.basicTranscript.copy();
                }
                AbstractFeature gene = null;
                if (this.parentId != null && this.geneCache.containsKey(this.parentId) && gene == null) {
                    gene = this.geneCache.get(this.parentId);
                    this.geneCache.remove(this.parentId);
                }
                if (gene != null) {
                    if (curTranscript.getName() == null && gene.getName() != null) {
                        curTranscript.setName(gene.getName());
                    }
                    curTranscript.setDescription("Transcript<br>" + curTranscript.getDescription() + "<br>--------<br>Gene<br>" + gene.getDescription());
                }
                for (Exon exon : exonSet) {
                    curTranscript.addExon(exon);
                }
                curTranscript.sortExons();
                if (this.fivePrimeUTR != null) {
                    this.adjustBoundariesByUTR(curTranscript, this.fivePrimeUTR, false);
                }
                if (this.threePrimeUTR != null) {
                    this.adjustBoundariesByUTR(curTranscript, this.threePrimeUTR, true);
                }
                transcriptList.add(curTranscript);
            }
            return transcriptList;
        }

        private void adjustBoundariesByUTR(BasicFeature transcript, Exon UTR, boolean threePrime) {
            UTR.setUTR(true);
            transcript.addExon(UTR);
            Exon exon = this.findMatchingExon(transcript.getExons(), UTR);
            if (exon != null) {
                boolean truncStart = exon.getStrand() == Strand.POSITIVE ^ threePrime;
                if (truncStart) {
                    exon.setStart(UTR.getEnd());
                } else {
                    exon.setEnd(UTR.getStart());
                }
            }
        }

        Exon findMatchingExon(Iterable<Exon> exons, IGVFeature cds) {
            for (Exon exon : exons) {
                if (!exon.contains(cds)) continue;
                return exon;
            }
            return null;
        }
    }

    public static class GFFCombiner {
        Map<String, GFF3Transcript> transcriptCache;
        Map<String, BasicFeature> geneCache;
        Queue<BasicFeature> subFeatures;

        public GFFCombiner() {
            int numElements = 50000;
            this.transcriptCache = new HashMap<String, GFF3Transcript>(numElements / 2);
            this.geneCache = new HashMap<String, BasicFeature>(numElements / 10);
            this.subFeatures = new ArrayDeque<BasicFeature>(numElements);
        }

        public GFFCombiner addFeatures(Iterator<Feature> rawIter) {
            while (rawIter.hasNext()) {
                this.addFeature((BasicFeature)rawIter.next());
            }
            return this;
        }

        public void addFeature(BasicFeature bf) {
            String featureType = bf.getType();
            if (featureType.equalsIgnoreCase("CDS_parts") || featureType.equalsIgnoreCase("intron") || GFFCodec.exonTerms.contains(featureType)) {
                this.subFeatures.add(bf);
            } else {
                this.createTranscript(bf);
            }
        }

        public List<Feature> combineFeatures() {
            BasicFeature bf;
            while ((bf = this.subFeatures.poll()) != null) {
                String featureType = bf.getType();
                if (featureType.equalsIgnoreCase("CDS_parts") || featureType.equalsIgnoreCase("intron")) {
                    String[] parentIds;
                    for (String pid : parentIds = bf.getParentIds()) {
                        this.getGFF3Transcript(pid).addCDSParts(bf.getChr(), bf.getStart(), bf.getEnd());
                    }
                    continue;
                }
                if (!GFFCodec.exonTerms.contains(featureType)) continue;
                this.incorporateExon(bf);
            }
            ArrayList<Feature> finalFeatures = new ArrayList<Feature>(this.transcriptCache.size());
            Iterator<GFF3Transcript> iter = this.transcriptCache.values().iterator();
            while (iter.hasNext()) {
                List<? extends Feature> igvTranscript = iter.next().createTranscript();
                if (igvTranscript != null) {
                    finalFeatures.addAll(igvTranscript);
                }
                iter.remove();
            }
            FeatureUtils.sortFeatureList(finalFeatures);
            return finalFeatures;
        }

        private void incorporateExon(BasicFeature bf) {
            String featureType = bf.getType();
            String[] parentIds = bf.getParentIds();
            if (!this.isValidParentIds(parentIds) && bf.getIdentifier() != null) {
                parentIds = new String[]{bf.getIdentifier()};
                bf.setParentIds(parentIds);
                this.createGFF3Transcript(bf.getIdentifier(), bf, parentIds[0]);
            }
            for (String pid : parentIds) {
                Exon exon = new Exon(bf.getChr(), bf.getStart(), bf.getEnd(), bf.getStrand());
                exon.setPhase(bf.getReadingFrame());
                if (bf.getColor() != null) {
                    exon.setColor(bf.getColor());
                }
                exon.setAttributes(bf.getAttributes());
                exon.setUTR(GFFCodec.utrTerms.contains(featureType));
                exon.setName(bf.getName());
                if (featureType.equalsIgnoreCase("exon")) {
                    this.getGFF3Transcript(pid).addExon(exon);
                    continue;
                }
                if (featureType.equalsIgnoreCase("CDS")) {
                    this.getGFF3Transcript(pid).addCDS(exon);
                    continue;
                }
                if (featureType.equalsIgnoreCase("five_prime_UTR") || featureType.equalsIgnoreCase("5'-UTR")) {
                    this.getGFF3Transcript(pid).setFivePrimeUTR(exon);
                    continue;
                }
                if (!featureType.equalsIgnoreCase("three_prime_UTR") && !featureType.equalsIgnoreCase("3'-UTR")) continue;
                this.getGFF3Transcript(pid).setThreePrimeUTR(exon);
            }
        }

        private void createTranscript(BasicFeature bf) {
            String featureType = bf.getType();
            String id = bf.getIdentifier();
            if (featureType.equalsIgnoreCase("gene")) {
                this.geneCache.put(id, bf);
            }
            String pid = null;
            String[] parentIds = bf.getParentIds();
            if (this.isValidParentIds(parentIds)) {
                pid = parentIds[0];
            }
            this.createGFF3Transcript(id, bf, pid);
        }

        private int parsePhase(String phaseString) {
            int phase = -1;
            if (!phaseString.equals(".")) {
                try {
                    phase = Integer.parseInt(phaseString);
                }
                catch (NumberFormatException numberFormatException) {
                    log.error("GFF3 error: non numeric phase: " + phaseString);
                }
            }
            return phase;
        }

        private GFF3Transcript getGFF3Transcript(String id) {
            GFF3Transcript transcript = this.transcriptCache.get(id);
            if (transcript == null) {
                transcript = new GFF3Transcript(id, this.geneCache);
                this.transcriptCache.put(id, transcript);
            }
            return transcript;
        }

        private GFF3Transcript createGFF3Transcript(String id, BasicFeature mRNA, String parentId) {
            GFF3Transcript transcript = new GFF3Transcript(id, this.geneCache);
            transcript.setBasicTranscript(mRNA, parentId);
            this.transcriptCache.put(id, transcript);
            return transcript;
        }

        private boolean isValidParentIds(String[] parentIds) {
            return parentIds != null && parentIds.length > 0 && parentIds[0] != null && parentIds[0].trim().length() > 0 && !parentIds[0].equals(".");
        }
    }
}

