/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.tribble;

import org.broad.igv.feature.genome.Genome;
import org.broad.igv.variant.vcf.VCFVariant;
import org.broad.tribble.AsciiFeatureCodec;
import org.broad.tribble.Feature;
import org.broad.tribble.readers.LineReader;
import org.broadinstitute.variant.variantcontext.VariantContext;

public class VCFWrapperCodec
extends AsciiFeatureCodec<VCFVariant> {
    AsciiFeatureCodec wrappedCodec;
    Genome genome;

    public VCFWrapperCodec(AsciiFeatureCodec wrappedCodec, Genome genome) {
        super(VCFVariant.class);
        this.wrappedCodec = wrappedCodec;
        this.genome = genome;
    }

    @Override
    public Feature decodeLoc(String line) {
        return this.wrappedCodec.decodeLoc(line);
    }

    @Override
    public VCFVariant decode(String line) {
        VariantContext vc = (VariantContext)this.wrappedCodec.decode(line);
        if (vc == null) {
            return null;
        }
        String chr = this.genome == null ? vc.getChr() : this.genome.getChromosomeAlias(vc.getChr());
        return new VCFVariant(vc, chr);
    }

    @Override
    public Object readHeader(LineReader reader) {
        return this.wrappedCodec.readHeader(reader);
    }

    @Override
    public boolean canDecode(String path) {
        return path.endsWith(".vcf") || path.endsWith(".vcf4") || path.endsWith(".vcf3");
    }
}

