/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.sf.samtools.seekablestream.SeekableStream;
import net.sf.samtools.seekablestream.SeekableStreamFactory;
import org.apache.log4j.Logger;
import org.broad.igv.feature.genome.FastaIndex;
import org.broad.igv.feature.genome.Sequence;
import org.broad.igv.util.ParsingUtils;

public class FastaIndexedSequence
implements Sequence {
    static Logger log = Logger.getLogger(FastaIndexedSequence.class);
    final FastaIndex index;
    final String path;
    final long contentLength;
    private final ArrayList<String> chromoNamesList;

    public FastaIndexedSequence(String path) throws IOException {
        this.path = path;
        this.contentLength = ParsingUtils.getContentLength(path);
        String indexPath = path + ".fai";
        if (ParsingUtils.getLastModified(path) > ParsingUtils.getLastModified(indexPath)) {
            log.warn("Index file for " + path + " is older than the file it indexes");
        }
        this.index = new FastaIndex(indexPath);
        this.chromoNamesList = new ArrayList<String>(this.index.getSequenceNames());
    }

    @Override
    public byte[] getSequence(String chr, int qstart, int qend) {
        FastaIndex.FastaSequenceIndexEntry idxEntry = this.index.getIndexEntry(chr);
        if (idxEntry == null) {
            return null;
        }
        try {
            int nBases;
            int start = Math.max(0, qstart);
            int end = Math.min((int)idxEntry.getSize(), qend);
            int bytesPerLine = idxEntry.getBytesPerLine();
            int basesPerLine = idxEntry.getBasesPerLine();
            int nEndBytes = bytesPerLine - basesPerLine;
            int startLine = start / basesPerLine;
            int endLine = end / basesPerLine;
            int base0 = startLine * basesPerLine;
            int offset = start - base0;
            long position = idxEntry.getPosition();
            long startByte = position + (long)(startLine * bytesPerLine) + (long)offset;
            int base1 = endLine * basesPerLine;
            int offset1 = end - base1;
            long endByte = Math.min(this.contentLength, position + (long)(endLine * bytesPerLine) + (long)offset1);
            if (startByte >= endByte) {
                return null;
            }
            byte[] allBytes = this.readBytes(startByte, endByte);
            ByteArrayOutputStream bos = new ByteArrayOutputStream(end - start);
            int srcPos = 0;
            int desPos = 0;
            int allBytesLength = allBytes.length;
            if (offset > 0) {
                nBases = Math.min(end - start, basesPerLine - offset);
                bos.write(allBytes, srcPos, nBases);
                srcPos += nBases + nEndBytes;
                desPos += nBases;
            }
            while (srcPos < allBytesLength) {
                nBases = Math.min(basesPerLine, allBytesLength - srcPos);
                bos.write(allBytes, srcPos, nBases);
                srcPos += nBases + nEndBytes;
                desPos += nBases;
            }
            return bos.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public byte getBase(String chr, int position) {
        throw new RuntimeException("getBase() is not implemented for class " + FastaIndexedSequence.class.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readBytes(long posStart, long posEnd) throws IOException {
        SeekableStream ss = null;
        try {
            ss = SeekableStreamFactory.getStreamFor(this.path);
            int nBytes = (int)(posEnd - posStart);
            byte[] bytes = new byte[nBytes];
            ss.seek(posStart);
            ss.readFully(bytes);
            byte[] byArray = bytes;
            return byArray;
        }
        finally {
            if (ss != null) {
                ss.close();
            }
        }
    }

    @Override
    public List<String> getChromosomeNames() {
        return this.chromoNamesList;
    }

    @Override
    public int getChromosomeLength(String chrname) {
        return this.index.getSequenceSize(chrname);
    }
}

