/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.dev.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.broad.igv.dev.db.DBManager;
import org.broad.igv.dev.db.DBProfile;
import org.broad.igv.dev.db.DBReader;
import org.broad.tribble.CloseableTribbleIterator;

public abstract class DBQueryReader<T>
extends DBReader {
    private static Logger log = Logger.getLogger(DBQueryReader.class);
    protected DBProfile.DBTable table;

    public DBQueryReader(DBProfile.DBTable table) {
        super(table);
        this.table = table;
    }

    @Override
    protected ResultSet executeQuery(String queryString) {
        try {
            Connection conn = DBManager.getConnection(this.locator);
            Statement st = conn.createStatement();
            ResultSet rs = st.executeQuery(queryString);
            return rs;
        }
        catch (SQLException e) {
            log.error("Database error", e);
            throw new RuntimeException("Database error", e);
        }
    }

    protected CloseableTribbleIterator loadIterator(PreparedStatement st) {
        try {
            ResultSet rs = st.executeQuery();
            return new ResultIterator(rs, false);
        }
        catch (SQLException e) {
            log.error("Database error", e);
            throw new RuntimeException("Database error", e);
        }
    }

    protected CloseableTribbleIterator loadIterator(String queryString) {
        return new ResultIterator(this.executeQuery(queryString));
    }

    protected abstract T processResult(ResultSet var1) throws SQLException;

    private class ResultIterator
    implements CloseableTribbleIterator {
        private ResultSet rs;
        private boolean closeStatement;
        private boolean hasNext;
        private T next;

        public ResultIterator(ResultSet rs) {
            this(rs, true);
        }

        public ResultIterator(ResultSet rs, boolean closeStatement) {
            this.rs = rs;
            this.closeStatement = closeStatement;
            try {
                this.hasNext = rs.next();
            }
            catch (SQLException e) {
                log.error("Database error", e);
                throw new RuntimeException("Database error", e);
            }
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public T next() {
            try {
                this.next = DBQueryReader.this.processResult(this.rs);
                this.hasNext = this.rs.next();
                if (!this.hasNext) {
                    DBManager.closeResources(this.rs, this.closeStatement ? this.rs.getStatement() : null, null);
                }
                return this.next;
            }
            catch (SQLException e) {
                log.error(e);
                throw new RuntimeException("Error processing SQL Results: " + e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove");
        }

        @Override
        public Iterator<T> iterator() {
            return this;
        }

        @Override
        public void close() {
            try {
                DBManager.closeResources(this.rs, this.rs.getStatement(), null);
            }
            catch (SQLException e) {
                log.error(e);
                throw new RuntimeException(e);
            }
        }
    }
}

