/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.dev.db;

import java.awt.Frame;
import java.io.File;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.dev.db.DBProfile;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.LoginDialog;
import org.broad.igv.util.ResourceLocator;

public class DBManager {
    private static Logger log = Logger.getLogger(DBManager.class);
    static Map<String, Connection> connectionPool = Collections.synchronizedMap(new HashMap());
    private static Map<String, String> driverMap = new HashMap<String, String>(2);
    private static final Set<Integer> blobTypes;

    public static Connection getConnection(ResourceLocator locator) {
        Connection conn;
        String url = locator.getPath();
        if (connectionPool.containsKey(url)) {
            conn = connectionPool.get(url);
            try {
                if (conn != null && !conn.isClosed()) {
                    return conn;
                }
                connectionPool.remove(url);
            }
            catch (SQLException e) {
                log.error("Bad connection", e);
                connectionPool.remove(url);
            }
        }
        if ((conn = DBManager.connect(locator)) != null) {
            connectionPool.put(url, conn);
            log.info("Connection pool size: " + connectionPool.size());
        }
        return conn;
    }

    public static void closeConnection(ResourceLocator locator) {
        String url = locator.getPath();
        if (connectionPool.containsKey(url)) {
            Connection conn = connectionPool.get(url);
            try {
                if (conn != null && !conn.isClosed()) {
                    conn.close();
                    connectionPool.remove(url);
                }
            }
            catch (SQLException e) {
                log.error(e);
            }
        }
    }

    private static String getSubprotocol(String url) {
        String[] tokens = url.split(":");
        return tokens[1];
    }

    private static Connection connect(ResourceLocator locator) {
        DBManager.createDriver(DBManager.getSubprotocol(locator.getPath()));
        try {
            return DriverManager.getConnection(locator.getPath(), locator.getUsername(), locator.getPassword());
        }
        catch (SQLException e) {
            int errorCode = e.getErrorCode();
            if (errorCode == 1044 || errorCode == 1045) {
                String resource = locator.getPath();
                Frame parent = Globals.isHeadless() ? null : IGV.getMainFrame();
                LoginDialog dlg = new LoginDialog(parent, false, resource, false);
                dlg.setVisible(true);
                if (dlg.isCanceled()) {
                    throw new RuntimeException("Must login to access" + resource);
                }
                locator.setUsername(dlg.getUsername());
                locator.setPassword(new String(dlg.getPassword()));
                return DBManager.connect(locator);
            }
            MessageUtils.showErrorMessage("<html>Error connecting to database: <br>" + e.getMessage(), e);
            return null;
        }
    }

    public static void shutdown() {
        for (Connection conn : connectionPool.values()) {
            if (conn == null) continue;
            try {
                conn.close();
            }
            catch (SQLException e) {
                log.error("Error shutting down " + conn.toString(), e);
            }
        }
        connectionPool.clear();
    }

    public static Class<?> createDriver(String subprotocol) {
        String driver = driverMap.get(subprotocol);
        try {
            return Class.forName(driver);
        }
        catch (ClassNotFoundException e) {
            log.error("Unable to create driver for " + subprotocol, e);
            throw new IllegalArgumentException(e);
        }
    }

    public static String createConnectionURL(String subprotocol, String host, String db, String port) {
        DBManager.createDriver(subprotocol);
        if (!new File(host).exists()) {
            host = "//" + host;
        }
        String url = "jdbc:" + subprotocol + ":" + host;
        if (port != null && !port.equals("")) {
            try {
                int iPort = Integer.parseInt(port);
                if (iPort >= 0) {
                    url = url + ":" + iPort;
                }
            }
            catch (NumberFormatException e) {
                log.error("Invalid port: " + port, e);
            }
        }
        if (db != null) {
            url = url + "/" + db;
        }
        return url;
    }

    static void closeResources(ResultSet rs, Statement st, Connection conn) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                log.error("Error closing sql connection", e);
            }
        }
    }

    public static String[] lineToArray(ResultSet rs, Map<Integer, String> columnIndexMap) throws SQLException {
        String[] colNames = DBProfile.DBTable.columnMapToArray(columnIndexMap);
        String[] tokens = new String[colNames.length];
        for (int cc = 0; cc < colNames.length; ++cc) {
            String sqlCol = colNames[cc];
            if (sqlCol == null) continue;
            tokens[cc] = DBManager.getStringFromResultSet(rs, sqlCol);
        }
        return tokens;
    }

    public static String[] lineToArray(ResultSet rs, int startColIndex, int endColIndex, boolean labelsOnly) throws SQLException {
        ResultSetMetaData md = rs.getMetaData();
        int colCount = Math.min(md.getColumnCount(), endColIndex) - startColIndex + 1;
        String[] tokens = new String[colCount];
        for (int cc = 0; cc < colCount; ++cc) {
            int sqlCol = cc + startColIndex;
            tokens[cc] = labelsOnly ? md.getColumnLabel(sqlCol) : DBManager.getStringFromResultSet(rs, sqlCol);
        }
        return tokens;
    }

    private static String getStringFromResultSet(ResultSet rs, String columnLabel) throws SQLException {
        return DBManager.getStringFromResultSet(rs, rs.findColumn(columnLabel));
    }

    private static String getStringFromResultSet(ResultSet rs, int sqlCol) throws SQLException {
        String s;
        int type = rs.getMetaData().getColumnType(sqlCol);
        if (blobTypes.contains(type)) {
            Blob b = rs.getBlob(sqlCol);
            s = new String(b.getBytes(1L, (int)b.length()));
        } else {
            s = rs.getString(sqlCol);
        }
        return s;
    }

    static {
        driverMap.put("mysql", "com.mysql.jdbc.Driver");
        driverMap.put("sqlite", "org.sqlite.JDBC");
        int[] blobtypes = new int[]{-2, 2004, -3, -4};
        blobTypes = new HashSet<Integer>(blobtypes.length);
        for (int bt : blobtypes) {
            blobTypes.add(bt);
        }
    }
}

