/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.dev;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.data.seg.SegmentedAsciiDataSet;
import org.broad.igv.dev.IParser;
import org.broad.igv.dev.IParserFactory;
import org.broad.igv.dev.db.DBProfile;
import org.broad.igv.dev.db.WholeTableDBReader;
import org.broad.igv.exceptions.ParserException;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.track.TrackType;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.tribble.readers.AsciiLineReader;

public class SegmentedReader {
    private static Logger log = Logger.getLogger(SegmentedReader.class);
    private Genome genome;
    private SegmentedAsciiDataSet dataset;
    private String[] headings;
    private boolean birdsuite = false;
    private int sampleColumn = 0;
    private int chrColumn = 1;
    private int startColumn = 2;
    private int endColumn = 3;
    private int dataColumn = 5;
    private ResourceLocator locator;

    public SegmentedReader(ResourceLocator locator) {
        this(locator, null);
    }

    public SegmentedReader(ResourceLocator locator, Genome genome) {
        this.locator = locator;
        this.genome = genome;
        if (locator.getPath().toLowerCase().endsWith("birdseye_canary_calls")) {
            this.birdsuite = true;
        }
    }

    public SegmentedAsciiDataSet loadFromFile() {
        this.dataset = new SegmentedAsciiDataSet(this.genome);
        if (this.birdsuite) {
            this.dataset.setTrackType(TrackType.CNV);
        }
        AsciiLineReader reader = null;
        String nextLine = null;
        int lineNumber = 0;
        IParser<String[], Integer> parser = IParserFactory.getIndexParser(new String[0]);
        try {
            reader = ParsingUtils.openAsciiReader(this.locator);
            lineNumber = this.readHeader(reader);
            while ((nextLine = reader.readLine()) != null && nextLine.trim().length() > 0) {
                ++lineNumber;
                String[] tokens = Globals.tabPattern.split(nextLine, -1);
                this.parseLine(parser, tokens);
            }
        }
        catch (IOException e) {
            if (nextLine != null && lineNumber != 0) {
                throw new ParserException(e.getMessage(), (Throwable)e, lineNumber, nextLine);
            }
            throw new RuntimeException(e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        this.dataset.sortLists();
        return this.dataset;
    }

    public SegmentedAsciiDataSet loadFromDB(DBProfile.DBTable table) {
        SegmentedDBReader reader = new SegmentedDBReader(table);
        return (SegmentedAsciiDataSet)reader.load();
    }

    private void parseComment(String comment, SegmentedAsciiDataSet dataset) {
        String tmp = comment.substring(1, comment.length());
        if (tmp.startsWith("track")) {
            ParsingUtils.parseTrackLine(tmp, dataset.getTrackProperties());
        } else {
            String[] tokens = tmp.split("=");
            String key = tokens[0].trim().toLowerCase();
            if (key.equals("type")) {
                if (tokens.length != 2) {
                    return;
                }
                try {
                    dataset.setTrackType(TrackType.valueOf(tokens[1].trim().toUpperCase()));
                }
                catch (Exception exception) {
                    log.error("Unknown track type: " + tokens[1].trim().toUpperCase());
                }
            }
        }
    }

    private int readHeader(AsciiLineReader reader) throws IOException {
        String nextLine = reader.readLine();
        int lineNumber = 0;
        while (nextLine.startsWith("#") || nextLine.trim().length() == 0) {
            ++lineNumber;
            if (nextLine.length() > 0) {
                this.parseComment(nextLine, this.dataset);
            }
            nextLine = reader.readLine();
        }
        this.headings = nextLine.split("\t");
        if (this.birdsuite) {
            this.sampleColumn = 0;
            this.dataColumn = 2;
            this.chrColumn = 3;
            this.startColumn = 4;
            this.endColumn = 5;
        } else {
            this.sampleColumn = 0;
            this.chrColumn = 1;
            this.startColumn = 2;
            this.endColumn = 3;
            this.dataColumn = this.headings.length - 1;
        }
        return lineNumber;
    }

    private <TContainer> void parseLine(IParser<TContainer, Integer> parser, TContainer rs) throws ParserException {
        int nTokens = parser.size(rs);
        if (nTokens > 4) {
            String sample = parser.getString(rs, this.sampleColumn);
            String chr = parser.getString(rs, this.chrColumn);
            int start = parser.getInt(rs, this.startColumn);
            int end = parser.getInt(rs, this.endColumn);
            float value = parser.getFloat(rs, this.dataColumn);
            if (this.genome != null) {
                chr = this.genome.getChromosomeAlias(chr);
            }
            String trackId = sample;
            StringBuffer desc = null;
            if (this.birdsuite) {
                desc = new StringBuffer();
                desc.append("<br>");
                desc.append(this.headings[6]);
                desc.append("=");
                desc.append(parser.getString(rs, 6));
            } else if (nTokens > 4) {
                desc = new StringBuffer();
                for (int i = 4; i < parser.size(rs) - 1; ++i) {
                    desc.append("<br>");
                    desc.append(this.headings[i]);
                    desc.append(": ");
                    desc.append(parser.getString(rs, i));
                }
            }
            String description = desc == null ? null : desc.toString();
            this.dataset.addSegment(trackId, chr, start, end, value, description);
        }
    }

    static /* synthetic */ String[] access$402(SegmentedReader x0, String[] x1) {
        x0.headings = x1;
        return x1;
    }

    private class SegmentedDBReader
    extends WholeTableDBReader<SegmentedAsciiDataSet> {
        private SegmentedDBReader(DBProfile.DBTable table) {
            super(table);
        }

        @Override
        protected SegmentedAsciiDataSet processResultSet(ResultSet rs) throws SQLException {
            IParser<ResultSet, Integer> parser = IParserFactory.getIndexParser(rs);
            this.readHeader(rs);
            while (rs.next()) {
                SegmentedReader.this.parseLine(parser, rs);
            }
            SegmentedReader.this.dataset.sortLists();
            return SegmentedReader.this.dataset;
        }

        private int readHeader(ResultSet rs) throws SQLException {
            SegmentedReader.this.dataset = new SegmentedAsciiDataSet(SegmentedReader.this.genome);
            SegmentedReader.this.dataColumn = rs.getMetaData().getColumnCount() - 1;
            SegmentedReader.access$402(SegmentedReader.this, new String[rs.getMetaData().getColumnCount()]);
            for (int cc = 0; cc < rs.getMetaData().getColumnCount(); ++cc) {
                ((SegmentedReader)SegmentedReader.this).headings[cc] = rs.getMetaData().getColumnLabel(cc + 1);
            }
            return 0;
        }
    }

    static enum Type {
        SEG,
        BIRDSUITE,
        NEXUS;

    }
}

