/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data.cufflinks;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.data.cufflinks.CufflinksValue;
import org.broad.igv.data.cufflinks.ExpDiffValue;
import org.broad.igv.data.cufflinks.FPKMValue;
import org.broad.igv.exceptions.DataLoadException;
import org.broad.igv.feature.Locus;
import org.broad.igv.util.ParsingUtils;
import org.broad.tribble.AbstractFeatureReader;
import org.broad.tribble.AsciiFeatureCodec;
import org.broad.tribble.CloseableTribbleIterator;
import org.broad.tribble.readers.LineReader;

public class CufflinksParser {
    private static Logger log = Logger.getLogger(CufflinksParser.class);

    public static List<? extends CufflinksValue> parse(String path) throws IOException {
        String s = path.toLowerCase();
        if (s.endsWith("fpkm_tracking")) {
            FpkmTrackingCodec codec = new FpkmTrackingCodec(path);
            return CufflinksParser.parse(codec, path);
        }
        if (s.endsWith("gene_exp.diff") || s.endsWith("cds_exp.diff")) {
            ExpDiffCodec codec = new ExpDiffCodec(path);
            return CufflinksParser.parse(codec, path);
        }
        throw new RuntimeException("Unsupported file type: " + path);
    }

    private static <T extends CufflinksValue> List<T> parse(AsciiFeatureCodec<T> codec, String path) throws IOException {
        ArrayList values = new ArrayList();
        AbstractFeatureReader reader = AbstractFeatureReader.getFeatureReader(path, codec, false);
        CloseableTribbleIterator iter = reader.iterator();
        while (iter.hasNext()) {
            values.add(iter.next());
        }
        return values;
    }

    private static class ExpDiffCodec
    extends CufflinksCodec<ExpDiffValue> {
        private static Logger log = Logger.getLogger(ExpDiffCodec.class);
        int geneColumn = 1;
        int locusColumn = 2;
        int xColumn = 6;
        int yColumn = 7;
        int logRatioColumn = 8;
        int sigColumn = 12;

        protected ExpDiffCodec(String path) {
            super(ExpDiffValue.class, path);
        }

        @Override
        public Object readHeader(String[] tokens) {
            for (int i = 0; i < tokens.length; ++i) {
                String tk = tokens[i];
                if (tk.equals("locus")) {
                    this.locusColumn = i;
                    continue;
                }
                if (tk.equals("gene")) {
                    this.geneColumn = i;
                    continue;
                }
                if (tk.equals("value_1")) {
                    this.xColumn = i;
                    continue;
                }
                if (tk.equals("value_2")) {
                    this.yColumn = i;
                    continue;
                }
                if (tk.startsWith("log2(")) {
                    this.logRatioColumn = i;
                    continue;
                }
                if (!tk.equals("significant")) continue;
                this.sigColumn = i;
            }
            return tokens;
        }

        @Override
        public ExpDiffValue decode(String[] tokens) {
            if (tokens[0].equalsIgnoreCase("test_id") || tokens[this.geneColumn].equalsIgnoreCase("gene_id")) {
                return null;
            }
            if (tokens.length >= this.sigColumn) {
                String locusString = tokens[this.locusColumn];
                if (locusString == null) {
                    return null;
                }
                Locus locus = new Locus(locusString);
                if (locus.getChr() == null) {
                    return null;
                }
                String logRatioStr = tokens[this.logRatioColumn];
                float logRatio = Float.parseFloat(logRatioStr);
                if (Float.isInfinite(logRatio) || Float.isNaN(logRatio)) {
                    log.info("LogRatio " + logRatioStr + " cannot be parsed as a float");
                    logRatio = Float.NaN;
                }
                float fpkmX = Float.parseFloat(tokens[this.xColumn]);
                float fpkmY = Float.parseFloat(tokens[this.yColumn]);
                String gene = tokens[this.geneColumn];
                String significant = tokens[this.sigColumn];
                return new ExpDiffValue(gene, locus.getChr(), locus.getStart() - 1, locus.getEnd(), logRatio, fpkmX, fpkmY, significant);
            }
            log.info("Unexpected # of columns.  Expected at least 12,  found " + tokens.length);
            return null;
        }

        @Override
        public ExpDiffValue decode(String line) {
            return this.decode(ParsingUtils.TAB_PATTERN.split(line));
        }
    }

    private static class FpkmTrackingCodec
    extends CufflinksCodec<FPKMValue> {
        int geneColumn = 4;
        int locusColumn = 6;
        int fpkmColumn = 6;
        int confLoColumn = 7;
        int confHiColumn = 8;
        int sigColumn = 12;

        FpkmTrackingCodec(String path) {
            super(FPKMValue.class, path);
        }

        @Override
        public Object readHeader(String[] tokens) {
            for (int i = 0; i < tokens.length; ++i) {
                String tk = tokens[i];
                if (tk.equals("locus")) {
                    this.locusColumn = i;
                    continue;
                }
                if (tk.equals("gene_short_name")) {
                    this.geneColumn = i;
                    continue;
                }
                if (tk.equals("FPKM")) {
                    this.fpkmColumn = i;
                    continue;
                }
                if (tk.equals("FPKM_conf_lo")) {
                    this.confLoColumn = i;
                    continue;
                }
                if (!tk.startsWith("FPKM_conf_hi")) continue;
                this.confHiColumn = i;
            }
            return tokens;
        }

        @Override
        public FPKMValue decode(String line) {
            return this.decode(ParsingUtils.TAB_PATTERN.split(line));
        }

        @Override
        public FPKMValue decode(String[] tokens) {
            if (tokens[0].equalsIgnoreCase("tracking_id") || tokens[this.geneColumn].equalsIgnoreCase("gene_short_name")) {
                return null;
            }
            if (tokens.length >= 12) {
                String locusString = tokens[this.locusColumn];
                if (locusString == null) {
                    return null;
                }
                Locus locus = new Locus(locusString);
                if (locus.getChr() == null) {
                    return null;
                }
                float fpkm = Float.parseFloat(tokens[this.fpkmColumn]);
                float confLo = Float.parseFloat(tokens[this.confLoColumn]);
                float confHi = Float.parseFloat(tokens[this.confHiColumn]);
                String gene = tokens[this.geneColumn];
                return new FPKMValue(gene, locus.getChr(), locus.getStart() - 1, locus.getEnd(), fpkm, confLo, confHi);
            }
            log.info("Unexpected # of columns.  Expected at least 12,  found " + tokens.length);
            return null;
        }
    }

    private static abstract class CufflinksCodec<T extends CufflinksValue>
    extends AsciiFeatureCodec<T> {
        String path;

        CufflinksCodec(Class<T> clazz, String path) {
            super(clazz);
            this.path = path;
        }

        protected abstract Object readHeader(String[] var1);

        @Override
        public Object readHeader(LineReader reader) {
            String headerLine = null;
            try {
                headerLine = reader.readLine();
                String[] tokens = ParsingUtils.TAB_PATTERN.split(headerLine);
                return this.readHeader(tokens);
            }
            catch (IOException e) {
                log.error(e.getMessage(), e);
                throw new DataLoadException("Error reading header: " + e.getMessage(), this.path);
            }
        }
    }
}

