/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.cli_plugin;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.broad.igv.DirectoryManager;
import org.broad.igv.PreferenceManager;
import org.broad.igv.cli_plugin.Argument;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.HttpUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PluginSpecReader {
    private static Logger log = Logger.getLogger(PluginSpecReader.class);
    protected String specPath;
    protected Document document;
    public static final String CUSTOM_PLUGINS_FILENAME = "custom_plugins.txt";
    public static final String BUILTIN_PLUGINS_FILENAME = "builtin_plugins.txt";
    public static final String COMMAND = "command";
    public static final String CMD_ARG = "cmd_arg";
    private static List<PluginSpecReader> pluginList;
    private List<Tool> tools;
    private static JAXBContext jc;

    private PluginSpecReader(String path) {
        this.specPath = path;
    }

    public static PluginSpecReader create(String path) {
        PluginSpecReader reader = new PluginSpecReader(path);
        if (!reader.parseDocument()) {
            return null;
        }
        return reader;
    }

    public static boolean isToolPathValid(String execPath) {
        if (execPath == null) {
            return false;
        }
        File execFile = new File(execPath = FileUtils.findExecutableOnPath(execPath));
        boolean pathValid = execFile.isFile();
        if (pathValid && !execFile.canExecute()) {
            log.error(execPath + " exists but is not executable. ");
            pathValid = false;
        }
        return pathValid;
    }

    public String getSpecPath() {
        return this.specPath;
    }

    public String getId() {
        return this.document.getDocumentElement().getAttribute("id");
    }

    private boolean parseDocument() {
        boolean success = false;
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            URL url = this.getClass().getResource(this.specPath);
            String uri = null;
            uri = url == null ? FileUtils.getAbsolutePath(this.specPath, new File(".").getAbsolutePath()) : url.toString();
            this.document = builder.parse(uri);
            success = this.document.getDocumentElement().getTagName().equals("cli_plugin");
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return success;
    }

    public List<Tool> getTools() {
        if (this.tools == null) {
            this.tools = PluginSpecReader.unmarshalElementsByTag(this.document.getDocumentElement(), "tool");
        }
        return this.tools;
    }

    private static <T> List<T> unmarshalElementsByTag(Element topElement, String tag) {
        NodeList nodes = topElement.getElementsByTagName(tag);
        ArrayList<T> outNodes = new ArrayList<T>(nodes.getLength());
        for (int nn = 0; nn < nodes.getLength(); ++nn) {
            outNodes.add(PluginSpecReader.unmarshal(nodes.item(nn)));
        }
        return outNodes;
    }

    public static List<PluginSpecReader> getPlugins() {
        if (pluginList == null) {
            pluginList = PluginSpecReader.generatePluginList();
        }
        return pluginList;
    }

    private static List<PluginSpecReader> generatePluginList() {
        ArrayList<PluginSpecReader> readers = new ArrayList<PluginSpecReader>();
        HashSet<String> pluginIds = new HashSet<String>();
        try {
            File[] checkDirs;
            for (File checkDir : checkDirs = new File[]{DirectoryManager.getIgvDirectory(), new File(FileUtils.getInstallDirectory()), new File(".")}) {
                File plugDir = new File(checkDir, "plugins");
                File[] possPlugins = plugDir.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith(".xml");
                    }
                });
                if (possPlugins == null) {
                    possPlugins = new File[]{};
                }
                ArrayList<String> possPluginsList = new ArrayList<String>(possPlugins.length);
                for (File fi : possPlugins) {
                    possPluginsList.add(fi.getAbsolutePath());
                }
                File customFile = new File(checkDir, CUSTOM_PLUGINS_FILENAME);
                if (customFile.canRead()) {
                    BufferedReader br = new BufferedReader(new FileReader(customFile));
                    possPluginsList.addAll(PluginSpecReader.getPluginPaths(br));
                }
                for (String pluginName : PluginSpecReader.getBuiltinPlugins()) {
                    possPluginsList.add("resources/" + pluginName);
                }
                for (String possPlugin : possPluginsList) {
                    PluginSpecReader reader = PluginSpecReader.create(possPlugin);
                    if (reader == null || pluginIds.contains(reader.getId())) continue;
                    readers.add(reader);
                    pluginIds.add(reader.getId());
                }
            }
        }
        catch (Exception e) {
            log.error(e);
        }
        return readers;
    }

    static List<String> getBuiltinPlugins() throws IOException {
        InputStream contentsStream = PluginSpecReader.class.getResourceAsStream("resources/builtin_plugins.txt");
        BufferedReader inReader = new BufferedReader(new InputStreamReader(contentsStream));
        return PluginSpecReader.getPluginPaths(inReader);
    }

    private static List<String> getPluginPaths(BufferedReader reader) throws IOException {
        String line;
        ArrayList<String> pluginPaths = new ArrayList<String>(3);
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("#")) continue;
            pluginPaths.add(line);
        }
        return pluginPaths;
    }

    public static void addCustomPlugin(String absolutePath) throws IOException {
        File outFile = new File(DirectoryManager.getIgvDirectory(), CUSTOM_PLUGINS_FILENAME);
        outFile.createNewFile();
        BufferedWriter writer = new BufferedWriter(new FileWriter(outFile));
        writer.write(absolutePath);
        writer.write("\n");
        writer.flush();
        writer.close();
        pluginList = PluginSpecReader.generatePluginList();
    }

    public String getName() {
        return this.document.getDocumentElement().getAttribute("name");
    }

    public String getToolPath(Tool tool) {
        String toolPath = PreferenceManager.getInstance().getToolPath(this.getId(), tool.name);
        if (toolPath == null) {
            toolPath = tool.defaultPath;
        }
        return toolPath;
    }

    static JAXBContext getJAXBContext() throws JAXBException {
        if (jc == null) {
            jc = JAXBContext.newInstance((Class[])new Class[]{Tool.class, Command.class, Argument.class, Parser.class});
        }
        return jc;
    }

    static <T> T unmarshal(Node node) {
        try {
            Unmarshaller u = PluginSpecReader.getJAXBContext().createUnmarshaller();
            u.setListener(ToolListener.getInstance());
            return (T)u.unmarshal(node);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public static URL[] getLibURLs(String[] libPaths, String absRoot) throws MalformedURLException {
        if (libPaths == null) {
            return null;
        }
        ArrayList<URL> urls = new ArrayList<URL>(libPaths.length);
        for (String libPath : libPaths) {
            String urlPath = libPath;
            if (!HttpUtils.isRemoteURL(urlPath) && !urlPath.startsWith("file://")) {
                urlPath = new File(urlPath).isAbsolute() ? "file://" + urlPath : "file://" + absRoot + "/" + urlPath;
            }
            urls.add(new URL(urlPath));
        }
        return urls.toArray(new URL[0]);
    }

    static {
        jc = null;
    }

    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class Command {
        @XmlAttribute
        public String name;
        @XmlAttribute
        public String cmd = "";
        @XmlElement(name="arg")
        public List<Argument> argumentList;
        @XmlElement
        public Parser parser;
    }

    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class Parser {
        public static String SOURCE_STDOUT = "stdout";
        @XmlAttribute
        boolean strict;
        @XmlAttribute
        String format;
        @XmlAttribute
        String decodingCodec;
        @XmlAttribute
        String source = SOURCE_STDOUT;
        @XmlElement
        String[] libs;
    }

    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class Tool {
        @XmlAttribute
        public String name;
        @XmlAttribute
        public String defaultPath;
        @XmlAttribute
        public boolean visible;
        @XmlAttribute
        public String toolUrl;
        @XmlElement(name="default")
        private Command defaultSettings;
        @XmlElement(name="command")
        public List<Command> commandList;
    }

    private static class ToolListener
    extends Unmarshaller.Listener {
        private static ToolListener instance;

        private ToolListener() {
        }

        public void afterUnmarshal(Object target, Object parent) {
            super.afterUnmarshal(target, parent);
            if (target instanceof Tool) {
                boolean hasDefault;
                Tool tool = (Tool)target;
                boolean bl = hasDefault = tool.defaultSettings != null;
                if (hasDefault) {
                    for (Command command : ((Tool)target).commandList) {
                        if (command.argumentList == null) {
                            command.argumentList = ((Tool)tool).defaultSettings.argumentList;
                        }
                        if (command.parser != null) continue;
                        command.parser = ((Tool)tool).defaultSettings.parser;
                    }
                }
            }
        }

        public static Unmarshaller.Listener getInstance() {
            if (instance == null) {
                instance = new ToolListener();
            }
            return instance;
        }
    }
}

