/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.cli_plugin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.cli_plugin.Argument;
import org.broad.igv.cli_plugin.PluginSource;
import org.broad.igv.cli_plugin.PluginSpecReader;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentInterval;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.track.FeatureSource;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.track.Track;
import org.broad.tribble.Feature;

public class PluginFeatureSource
extends PluginSource
implements FeatureSource<Feature> {
    private static Logger log = Logger.getLogger(PluginFeatureSource.class);

    private PluginFeatureSource() {
    }

    public PluginFeatureSource(List<String> commands, LinkedHashMap<Argument, Object> arguments, PluginSpecReader.Parser parsingAttrs, String specPath) {
        super(commands, arguments, parsingAttrs, specPath);
    }

    @Override
    protected String createTempFile(Track track, Argument argument, String chr, int start, int end, int zoom) throws IOException {
        if (track instanceof AlignmentTrack) {
            return this.createTempFileForAlignmentTrack((AlignmentTrack)track, argument, chr, start, end, zoom);
        }
        FeatureTrack fTrack = (FeatureTrack)track;
        List<Feature> features = fTrack.getFeatures(chr, start, end);
        return super.createTempFile(features, argument);
    }

    private String createTempFileForAlignmentTrack(AlignmentTrack track, Argument argument, String chr, int start, int end, int zoom) throws IOException {
        Collection<AlignmentInterval> loadedIntervals = track.getDataManager().getAllLoadedIntervals();
        ArrayList<Alignment> alignments = new ArrayList<Alignment>();
        for (AlignmentInterval interval : loadedIntervals) {
            if (!interval.overlaps(chr, start, end, zoom)) continue;
            Iterator<Alignment> iter = interval.getAlignmentIterator();
            while (iter.hasNext()) {
                Alignment al = iter.next();
                if (al.getStart() > end || al.getEnd() < start) continue;
                alignments.add(al);
            }
        }
        return super.createTempFile(alignments, argument);
    }

    @Override
    public final Iterator<Feature> getFeatures(String chr, int start, int end) throws IOException {
        return super.getFeatures(chr, start, end, -1);
    }

    @Override
    public List<LocusScore> getCoverageScores(String chr, int start, int end, int zoom) {
        return null;
    }

    @Override
    public final int getFeatureWindowSize() {
        int featureWindowSize = this.getMinSizeFromTracks(this.arguments.values());
        return featureWindowSize;
    }

    private int getMinSizeFromTracks(Iterable tracks) {
        int featureWindowSize = Integer.MAX_VALUE;
        for (Object val : tracks) {
            int tmpSize = Integer.MAX_VALUE;
            if (val instanceof FeatureTrack) {
                FeatureTrack track = (FeatureTrack)val;
                tmpSize = track.getFeatureWindowSize();
            } else if (val instanceof List) {
                featureWindowSize = this.getMinSizeFromTracks((List)val);
            }
            featureWindowSize = Math.min(featureWindowSize, tmpSize);
        }
        return featureWindowSize;
    }

    @Override
    public final void setFeatureWindowSize(int size) {
    }
}

