/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.cli_plugin;

import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.broad.igv.cli_plugin.Argument;
import org.broad.igv.cli_plugin.AsciiDecoder;
import org.broad.igv.cli_plugin.AsciiEncoder;
import org.broad.igv.cli_plugin.FeatureDecoder;
import org.broad.igv.cli_plugin.FeatureEncoder;
import org.broad.igv.cli_plugin.LineFeatureDecoder;
import org.broad.igv.cli_plugin.LineFeatureEncoder;
import org.broad.tribble.Feature;

public abstract class PluginCodec<E extends Feature, D extends Feature>
implements FeatureEncoder<E>,
FeatureDecoder<E> {
    protected List<String> commands;
    protected Pattern columnDelimiter = Pattern.compile("\\t");
    protected AsciiEncoder<E> encoder;
    protected AsciiDecoder<D> decoder;

    public PluginCodec(LineFeatureEncoder<E> lineFeatureEncoder, LineFeatureDecoder<D> lineFeatureDecoder) {
        this.encoder = new AsciiEncoder<E>(lineFeatureEncoder);
        this.decoder = new AsciiDecoder<D>(lineFeatureDecoder);
    }

    @Override
    public void setInputs(List<String> commands, Map<Argument, Object> argumentMap) {
        this.encoder.setInputs(commands, argumentMap);
        this.decoder.setInputs(commands, argumentMap);
    }

    @Override
    public void setAttributes(List<Map<String, Object>> attributes) {
        this.decoder.setAttributes(attributes);
    }

    @Override
    public Map<String, Object> encodeAll(OutputStream outputStream, Iterator<E> features) {
        return this.encoder.encodeAll(outputStream, features);
    }

    public D decode(String line) {
        return this.decoder.decode(line);
    }
}

