/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.cli_plugin;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.cli_plugin.Argument;
import org.broad.igv.cli_plugin.FeatureDecoder;
import org.broad.igv.cli_plugin.LineFeatureDecoder;
import org.broad.tribble.AsciiFeatureCodec;
import org.broad.tribble.Feature;

public class AsciiDecoder<D extends Feature>
implements FeatureDecoder<D> {
    private static Logger log = Logger.getLogger(AsciiDecoder.class);
    protected LineFeatureDecoder<D> lineFeatureDecoder;

    public AsciiDecoder() {
    }

    public AsciiDecoder(LineFeatureDecoder<D> lineFeatureDecoder) {
        this.lineFeatureDecoder = lineFeatureDecoder;
    }

    @Override
    public Iterator<D> decodeAll(InputStream is, boolean strictParsing) throws IOException {
        String line;
        ArrayList<D> featuresList = new ArrayList<D>();
        BufferedReader bis = new BufferedReader(new InputStreamReader(is));
        while ((line = bis.readLine()) != null) {
            try {
                D feat = this.decode(line);
                if (feat == null) continue;
                featuresList.add(feat);
            }
            catch (Exception e) {
                log.error(e);
                if (!strictParsing) continue;
                throw new RuntimeException(e);
            }
        }
        is.close();
        return featuresList.iterator();
    }

    public D decode(String line) {
        return this.lineFeatureDecoder.decode(line);
    }

    @Override
    public void setAttributes(List<Map<String, Object>> attributes) {
    }

    @Override
    public void setInputs(List<String> commands, Map<Argument, Object> argumentMap) {
    }

    public static class DecoderWrapper<T extends Feature>
    extends AsciiDecoder<T>
    implements LineFeatureDecoder<T> {
        private AsciiFeatureCodec<T> wrappedCodec;

        public DecoderWrapper(AsciiFeatureCodec<T> wrappedCodec) {
            this.wrappedCodec = wrappedCodec;
            this.lineFeatureDecoder = this;
        }

        @Override
        public T decode(String line) {
            return this.wrappedCodec.decode(line);
        }
    }
}

