/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv;

import java.io.File;
import java.io.IOException;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileSystemView;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;
import org.broad.igv.Globals;
import org.broad.igv.PreferenceManager;
import org.broad.igv.exceptions.DataLoadException;
import org.broad.igv.ui.util.FileDialogUtils;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.RuntimeUtils;

public class DirectoryManager {
    private static Logger log = Logger.getLogger(DirectoryManager.class);
    private static File USER_HOME;
    private static File USER_DIRECTORY;
    private static File IGV_DIRECTORY;
    private static File GENOME_CACHE_DIRECTORY;
    private static File GENE_LIST_DIRECTORY;
    private static File BAM_CACHE_DIRECTORY;
    public static final String IGV_DIR_USERPREF = "igvDir";

    private static File getUserHome() {
        if (USER_HOME == null) {
            String userHomeString = System.getProperty("user.home");
            USER_HOME = new File(userHomeString);
        }
        return USER_HOME;
    }

    public static synchronized File getUserDirectory() {
        if (USER_DIRECTORY == null) {
            System.out.print("Fetching user directory... ");
            USER_DIRECTORY = FileSystemView.getFileSystemView().getDefaultDirectory();
            if (USER_DIRECTORY == null) {
                USER_DIRECTORY = DirectoryManager.getUserHome();
            }
        }
        return USER_DIRECTORY;
    }

    public static File getIgvDirectory() {
        if (IGV_DIRECTORY == null) {
            if (System.getProperty("os.name").startsWith("Windows")) {
                try {
                    Runtime.getRuntime().exec("attrib -r \"" + DirectoryManager.getUserDirectory().getAbsolutePath() + "\"");
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if ((IGV_DIRECTORY = DirectoryManager.getIgvDirectoryOverride()) == null) {
                File rootDir = DirectoryManager.getUserHome();
                IGV_DIRECTORY = new File(rootDir, "igv");
                if (!IGV_DIRECTORY.exists()) {
                    File legacyDirectory = null;
                    try {
                        legacyDirectory = DirectoryManager.getLegacyIGVDirectory();
                        if (legacyDirectory.exists()) {
                            log.info("Copying " + legacyDirectory + " => " + IGV_DIRECTORY);
                            org.apache.commons.io.FileUtils.copyDirectory(legacyDirectory, IGV_DIRECTORY);
                        }
                    }
                    catch (IOException e) {
                        log.error("Error copying igv directory " + legacyDirectory + " => " + IGV_DIRECTORY, e);
                    }
                }
                if (!IGV_DIRECTORY.exists()) {
                    try {
                        boolean wasSuccessful = IGV_DIRECTORY.mkdir();
                        if (!wasSuccessful) {
                            System.err.println("Failed to create user directory!");
                            IGV_DIRECTORY = null;
                        }
                    }
                    catch (Exception e) {
                        log.error("Error creating igv directory", e);
                    }
                }
            }
            if (IGV_DIRECTORY == null || !IGV_DIRECTORY.exists() || !DirectoryManager.canWrite(IGV_DIRECTORY)) {
                if (Globals.isHeadless() || Globals.isSuppressMessages()) {
                    System.err.println("Cannot write to igv directory: " + IGV_DIRECTORY.getAbsolutePath());
                    IGV_DIRECTORY = new File(".").getParentFile();
                } else {
                    File parentDirectory;
                    int option = JOptionPane.showConfirmDialog(null, "<html>The default IGV directory (" + IGV_DIRECTORY + ") " + "cannot be accessed.  Click Yes to choose a new folder or No to exit.<br>" + "This folder will be used to create the 'igv' directory", "IGV Directory Error", 0);
                    if (option == 0 && (parentDirectory = FileDialogUtils.chooseDirectory("Select a location for the igv directory", null)) != null) {
                        IGV_DIRECTORY = new File(parentDirectory, "igv");
                        IGV_DIRECTORY.mkdir();
                        Preferences prefs = Preferences.userNodeForPackage(Globals.class);
                        prefs.put(IGV_DIR_USERPREF, IGV_DIRECTORY.getAbsolutePath());
                    }
                }
            }
            if (IGV_DIRECTORY == null || !IGV_DIRECTORY.canRead()) {
                throw new DataLoadException("Cannot read from user directory", IGV_DIRECTORY.getAbsolutePath());
            }
            if (!DirectoryManager.canWrite(IGV_DIRECTORY)) {
                throw new DataLoadException("Cannot write to user directory", IGV_DIRECTORY.getAbsolutePath());
            }
            log.info("IGV Directory: " + IGV_DIRECTORY.getAbsolutePath());
        }
        return IGV_DIRECTORY;
    }

    private static File getIgvDirectoryOverride() {
        Preferences userPrefs = null;
        File override = null;
        try {
            userPrefs = Preferences.userNodeForPackage(Globals.class);
            String userDir = userPrefs.get(IGV_DIR_USERPREF, null);
            if (userDir != null && !(override = new File(userDir)).exists()) {
                override = null;
                userPrefs.remove(IGV_DIR_USERPREF);
            }
        }
        catch (Exception e) {
            userPrefs.remove(IGV_DIR_USERPREF);
            override = null;
            System.err.println("Error creating user directory");
            e.printStackTrace();
        }
        return override;
    }

    public static File getGenomeCacheDirectory() {
        if (GENOME_CACHE_DIRECTORY == null) {
            GENOME_CACHE_DIRECTORY = new File(DirectoryManager.getIgvDirectory(), "genomes");
            if (!GENOME_CACHE_DIRECTORY.exists()) {
                GENOME_CACHE_DIRECTORY.mkdir();
            }
            if (!GENOME_CACHE_DIRECTORY.canRead()) {
                throw new DataLoadException("Cannot read from user directory", GENOME_CACHE_DIRECTORY.getAbsolutePath());
            }
            if (!GENOME_CACHE_DIRECTORY.canWrite()) {
                throw new DataLoadException("Cannot write to user directory", GENOME_CACHE_DIRECTORY.getAbsolutePath());
            }
        }
        return GENOME_CACHE_DIRECTORY;
    }

    public static File getGeneListDirectory() {
        if (GENE_LIST_DIRECTORY == null) {
            GENE_LIST_DIRECTORY = new File(DirectoryManager.getIgvDirectory(), "lists");
            if (!GENE_LIST_DIRECTORY.exists()) {
                GENE_LIST_DIRECTORY.mkdir();
            }
            if (!GENE_LIST_DIRECTORY.canRead()) {
                throw new DataLoadException("Cannot read from user directory", GENE_LIST_DIRECTORY.getAbsolutePath());
            }
            if (!GENE_LIST_DIRECTORY.canWrite()) {
                throw new DataLoadException("Cannot write to user directory", GENE_LIST_DIRECTORY.getAbsolutePath());
            }
        }
        return GENE_LIST_DIRECTORY;
    }

    public static synchronized File getCacheDirectory() {
        File defaultDir;
        if (BAM_CACHE_DIRECTORY == null && (defaultDir = DirectoryManager.getIgvDirectory()).exists() && !(BAM_CACHE_DIRECTORY = new File(defaultDir, "bam")).exists()) {
            BAM_CACHE_DIRECTORY.mkdir();
        }
        return BAM_CACHE_DIRECTORY;
    }

    public static synchronized File getSamDirectory() {
        File samDir = new File(DirectoryManager.getIgvDirectory(), "sam");
        if (!samDir.exists()) {
            samDir.mkdir();
        }
        return samDir;
    }

    public static synchronized File getLogFile() throws IOException {
        File logFile = new File(DirectoryManager.getIgvDirectory(), "igv.log");
        if (!logFile.exists()) {
            logFile.createNewFile();
        }
        return logFile;
    }

    public static synchronized File getPreferencesFile() {
        File oldFile;
        File igvDirectoy = DirectoryManager.getIgvDirectory();
        File igvPropertyFile = new File(igvDirectoy, "prefs.properties");
        if (!igvPropertyFile.exists() && (oldFile = DirectoryManager.getLegacyPreferencesFile()).exists()) {
            try {
                org.apache.commons.io.FileUtils.copyFile(oldFile, igvPropertyFile);
            }
            catch (IOException e) {
                log.error("Error copy property file from: " + oldFile + " to: " + igvPropertyFile, e);
            }
        }
        if (!igvPropertyFile.exists()) {
            try {
                igvPropertyFile.createNewFile();
            }
            catch (IOException e) {
                log.error("Could not create property file: " + igvPropertyFile, e);
            }
        }
        return igvPropertyFile;
    }

    public static Boolean moveIGVDirectory(File newIGVDirectory) {
        if (newIGVDirectory.equals(IGV_DIRECTORY)) {
            return false;
        }
        if (IGV_DIRECTORY != null && IGV_DIRECTORY.exists()) {
            File oldDirectory = IGV_DIRECTORY;
            try {
                log.info("Moving igv directory from " + oldDirectory.getParent() + " to " + newIGVDirectory.getAbsolutePath());
                org.apache.commons.io.FileUtils.copyDirectory(IGV_DIRECTORY, newIGVDirectory);
                IGV_DIRECTORY = newIGVDirectory;
                Preferences prefs = Preferences.userNodeForPackage(Globals.class);
                prefs.put(IGV_DIR_USERPREF, newIGVDirectory.getAbsolutePath());
                PreferenceManager.getInstance().setPrefsFile(DirectoryManager.getPreferencesFile().getAbsolutePath());
            }
            catch (IOException e) {
                log.error("Error copying IGV directory", e);
                MessageUtils.showMessage("<html>Error moving IGV directory:<br/>&nbsp;nbsp;" + e.getMessage());
                return false;
            }
            LogManager.shutdown();
            DirectoryManager.initializeLog();
            try {
                DirectoryManager.deleteDirectory(oldDirectory);
            }
            catch (IOException e) {
                log.error("An error was encountered deleting the previous IGV directory", e);
                MessageUtils.showMessage("<html>An error was encountered deleting the previous IGV directory (" + e.getMessage() + "):<br>&nbsp;nbsp;nbsp;" + oldDirectory.getAbsolutePath() + "<br>Remaining files should be manually deleted.");
            }
        }
        GENOME_CACHE_DIRECTORY = null;
        GENE_LIST_DIRECTORY = null;
        BAM_CACHE_DIRECTORY = null;
        return true;
    }

    private static void deleteDirectory(File oldDirectory) throws IOException {
        if (Globals.IS_LINUX || Globals.IS_MAC) {
            String[] cmd = new String[]{"rm", "-rf", oldDirectory.getAbsolutePath()};
            String result = RuntimeUtils.executeShellCommand(cmd, null, null);
            if (result != null && result.trim().length() > 0) {
                log.info("Response from 'rm -rf': " + result);
            }
        } else {
            FileUtils.deleteDir(oldDirectory);
        }
    }

    private static synchronized File getLegacyPreferencesFile() {
        File rootDir = DirectoryManager.getLegacyIGVDirectory();
        return new File(rootDir, "prefs.properties");
    }

    private static File getLegacyIGVDirectory() {
        File rootDir = DirectoryManager.getUserHome();
        rootDir = Globals.IS_MAC ? new File(rootDir, ".igv") : new File(rootDir, "igv");
        return rootDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean canWrite(File directory) {
        if (Globals.IS_WINDOWS) {
            File testFile = null;
            try {
                testFile = new File(directory, "igv332415dsfjdsklt.testfile");
                if (testFile.exists()) {
                    testFile.delete();
                }
                testFile.deleteOnExit();
                testFile.createNewFile();
                boolean bl = testFile.exists();
                return bl;
            }
            catch (IOException e) {
                boolean bl = false;
                return bl;
            }
            finally {
                if (testFile.exists()) {
                    testFile.delete();
                }
            }
        }
        return directory.canWrite();
    }

    public static void initializeLog() {
        Logger logger = Logger.getRootLogger();
        PatternLayout layout = new PatternLayout();
        layout.setConversionPattern("%p [%d{ISO8601}] [%F:%L]  %m%n");
        try {
            File logFile = DirectoryManager.getLogFile();
            RollingFileAppender appender = new RollingFileAppender();
            appender.setName("IGV_ROLLING_APPENDER");
            appender.setFile(logFile.getAbsolutePath());
            appender.setThreshold(Level.ALL);
            appender.setMaxFileSize("1000KB");
            appender.setMaxBackupIndex(1);
            appender.setLayout(layout);
            appender.setAppend(true);
            appender.activateOptions();
            logger.addAppender(appender);
        }
        catch (IOException e) {
            System.err.println("Error creating log file");
            e.printStackTrace();
            ConsoleAppender consoleAppender = new ConsoleAppender();
            logger.addAppender(consoleAppender);
        }
    }
}

