/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.model;

import com.google.java.contract.Ensures;
import com.google.java.contract.Invariant;
import com.google.java.contract.Requires;
import com.google.java.contract.core.model.ElementKind;
import com.google.java.contract.core.model.ElementVisitor;
import com.google.java.contract.core.model.QualifiedElementModel;
import com.google.java.contract.core.model.TypeName;

@Invariant(value={"type != null"})
public class VariableModel
extends QualifiedElementModel {
    protected TypeName type;

    @Requires(value={"kind != null", "name != null", "type != null", "kind == ElementKind.CONSTANT || kind == ElementKind.FIELD || kind == ElementKind.PARAMETER"})
    public VariableModel(ElementKind elementKind, String string, TypeName typeName) {
        super(elementKind, string);
        this.type = typeName;
    }

    @Requires(value={"that != null"})
    @Ensures(value={"getEnclosingElement() == null"})
    public VariableModel(VariableModel variableModel) {
        super(variableModel);
        this.type = variableModel.type;
    }

    @Override
    public VariableModel clone() {
        return new VariableModel(this);
    }

    @Ensures(value={"result != null"})
    public TypeName getType() {
        return this.type;
    }

    @Requires(value={"type != null"})
    public void setType(TypeName typeName) {
        this.type = typeName;
    }

    @Override
    public void accept(ElementVisitor elementVisitor) {
        elementVisitor.visitVariable(this);
    }
}

