/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.util;

import java.util.ArrayList;
import java.util.Stack;
import org.jgrapht.util.FibonacciHeapNode;

public class FibonacciHeap<T> {
    private static final double oneOverLogPhi = 1.0 / Math.log((1.0 + Math.sqrt(5.0)) / 2.0);
    private FibonacciHeapNode<T> minNode;
    private int nNodes;

    public boolean isEmpty() {
        return this.minNode == null;
    }

    public void clear() {
        this.minNode = null;
        this.nNodes = 0;
    }

    public void decreaseKey(FibonacciHeapNode<T> fibonacciHeapNode, double d2) {
        if (d2 > fibonacciHeapNode.key) {
            throw new IllegalArgumentException("decreaseKey() got larger key value");
        }
        fibonacciHeapNode.key = d2;
        FibonacciHeapNode fibonacciHeapNode2 = fibonacciHeapNode.parent;
        if (fibonacciHeapNode2 != null && fibonacciHeapNode.key < fibonacciHeapNode2.key) {
            this.cut(fibonacciHeapNode, fibonacciHeapNode2);
            this.cascadingCut(fibonacciHeapNode2);
        }
        if (fibonacciHeapNode.key < this.minNode.key) {
            this.minNode = fibonacciHeapNode;
        }
    }

    public void delete(FibonacciHeapNode<T> fibonacciHeapNode) {
        this.decreaseKey(fibonacciHeapNode, Double.NEGATIVE_INFINITY);
        this.removeMin();
    }

    public void insert(FibonacciHeapNode<T> fibonacciHeapNode, double d2) {
        fibonacciHeapNode.key = d2;
        if (this.minNode != null) {
            fibonacciHeapNode.left = this.minNode;
            fibonacciHeapNode.right = this.minNode.right;
            this.minNode.right = fibonacciHeapNode;
            fibonacciHeapNode.right.left = fibonacciHeapNode;
            if (d2 < this.minNode.key) {
                this.minNode = fibonacciHeapNode;
            }
        } else {
            this.minNode = fibonacciHeapNode;
        }
        ++this.nNodes;
    }

    public FibonacciHeapNode<T> min() {
        return this.minNode;
    }

    public FibonacciHeapNode<T> removeMin() {
        FibonacciHeapNode<T> fibonacciHeapNode = this.minNode;
        if (fibonacciHeapNode != null) {
            FibonacciHeapNode fibonacciHeapNode2 = fibonacciHeapNode.child;
            for (int i2 = fibonacciHeapNode.degree; i2 > 0; --i2) {
                FibonacciHeapNode fibonacciHeapNode3 = fibonacciHeapNode2.right;
                fibonacciHeapNode2.left.right = fibonacciHeapNode2.right;
                fibonacciHeapNode2.right.left = fibonacciHeapNode2.left;
                fibonacciHeapNode2.left = this.minNode;
                fibonacciHeapNode2.right = this.minNode.right;
                this.minNode.right = fibonacciHeapNode2;
                fibonacciHeapNode2.right.left = fibonacciHeapNode2;
                fibonacciHeapNode2.parent = null;
                fibonacciHeapNode2 = fibonacciHeapNode3;
            }
            fibonacciHeapNode.left.right = fibonacciHeapNode.right;
            fibonacciHeapNode.right.left = fibonacciHeapNode.left;
            if (fibonacciHeapNode == fibonacciHeapNode.right) {
                this.minNode = null;
            } else {
                this.minNode = fibonacciHeapNode.right;
                this.consolidate();
            }
            --this.nNodes;
        }
        return fibonacciHeapNode;
    }

    public int size() {
        return this.nNodes;
    }

    public static <T> FibonacciHeap<T> union(FibonacciHeap<T> fibonacciHeap, FibonacciHeap<T> fibonacciHeap2) {
        FibonacciHeap<T> fibonacciHeap3 = new FibonacciHeap<T>();
        if (fibonacciHeap != null && fibonacciHeap2 != null) {
            fibonacciHeap3.minNode = fibonacciHeap.minNode;
            if (fibonacciHeap3.minNode != null) {
                if (fibonacciHeap2.minNode != null) {
                    fibonacciHeap3.minNode.right.left = fibonacciHeap2.minNode.left;
                    fibonacciHeap2.minNode.left.right = fibonacciHeap3.minNode.right;
                    fibonacciHeap3.minNode.right = fibonacciHeap2.minNode;
                    fibonacciHeap2.minNode.left = fibonacciHeap3.minNode;
                    if (fibonacciHeap2.minNode.key < fibonacciHeap.minNode.key) {
                        fibonacciHeap3.minNode = fibonacciHeap2.minNode;
                    }
                }
            } else {
                fibonacciHeap3.minNode = fibonacciHeap2.minNode;
            }
            fibonacciHeap3.nNodes = fibonacciHeap.nNodes + fibonacciHeap2.nNodes;
        }
        return fibonacciHeap3;
    }

    public String toString() {
        if (this.minNode == null) {
            return "FibonacciHeap=[]";
        }
        Stack stack = new Stack();
        stack.push(this.minNode);
        StringBuffer stringBuffer = new StringBuffer(512);
        stringBuffer.append("FibonacciHeap=[");
        while (!stack.empty()) {
            FibonacciHeapNode fibonacciHeapNode = (FibonacciHeapNode)stack.pop();
            stringBuffer.append(fibonacciHeapNode);
            stringBuffer.append(", ");
            if (fibonacciHeapNode.child != null) {
                stack.push(fibonacciHeapNode.child);
            }
            FibonacciHeapNode fibonacciHeapNode2 = fibonacciHeapNode;
            fibonacciHeapNode = fibonacciHeapNode.right;
            while (fibonacciHeapNode != fibonacciHeapNode2) {
                stringBuffer.append(fibonacciHeapNode);
                stringBuffer.append(", ");
                if (fibonacciHeapNode.child != null) {
                    stack.push(fibonacciHeapNode.child);
                }
                fibonacciHeapNode = fibonacciHeapNode.right;
            }
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    protected void cascadingCut(FibonacciHeapNode<T> fibonacciHeapNode) {
        FibonacciHeapNode fibonacciHeapNode2 = fibonacciHeapNode.parent;
        if (fibonacciHeapNode2 != null) {
            if (!fibonacciHeapNode.mark) {
                fibonacciHeapNode.mark = true;
            } else {
                this.cut(fibonacciHeapNode, fibonacciHeapNode2);
                this.cascadingCut(fibonacciHeapNode2);
            }
        }
    }

    protected void consolidate() {
        FibonacciHeapNode fibonacciHeapNode;
        int n2;
        int n3;
        int n4 = (int)Math.floor(Math.log(this.nNodes) * oneOverLogPhi) + 1;
        ArrayList<FibonacciHeapNode> arrayList = new ArrayList<FibonacciHeapNode>(n4);
        for (n3 = 0; n3 < n4; ++n3) {
            arrayList.add(null);
        }
        n3 = 0;
        FibonacciHeapNode fibonacciHeapNode2 = this.minNode;
        if (fibonacciHeapNode2 != null) {
            ++n3;
            fibonacciHeapNode2 = fibonacciHeapNode2.right;
            while (fibonacciHeapNode2 != this.minNode) {
                ++n3;
                fibonacciHeapNode2 = fibonacciHeapNode2.right;
            }
        }
        while (n3 > 0) {
            FibonacciHeapNode fibonacciHeapNode3;
            n2 = fibonacciHeapNode2.degree;
            fibonacciHeapNode = fibonacciHeapNode2.right;
            while ((fibonacciHeapNode3 = (FibonacciHeapNode)arrayList.get(n2)) != null) {
                if (fibonacciHeapNode2.key > fibonacciHeapNode3.key) {
                    FibonacciHeapNode fibonacciHeapNode4 = fibonacciHeapNode3;
                    fibonacciHeapNode3 = fibonacciHeapNode2;
                    fibonacciHeapNode2 = fibonacciHeapNode4;
                }
                this.link(fibonacciHeapNode3, fibonacciHeapNode2);
                arrayList.set(n2, null);
                ++n2;
            }
            arrayList.set(n2, fibonacciHeapNode2);
            fibonacciHeapNode2 = fibonacciHeapNode;
            --n3;
        }
        this.minNode = null;
        for (n2 = 0; n2 < n4; ++n2) {
            fibonacciHeapNode = (FibonacciHeapNode)arrayList.get(n2);
            if (fibonacciHeapNode == null) continue;
            if (this.minNode != null) {
                fibonacciHeapNode.left.right = fibonacciHeapNode.right;
                fibonacciHeapNode.right.left = fibonacciHeapNode.left;
                fibonacciHeapNode.left = this.minNode;
                fibonacciHeapNode.right = this.minNode.right;
                this.minNode.right = fibonacciHeapNode;
                fibonacciHeapNode.right.left = fibonacciHeapNode;
                if (!(fibonacciHeapNode.key < this.minNode.key)) continue;
                this.minNode = fibonacciHeapNode;
                continue;
            }
            this.minNode = fibonacciHeapNode;
        }
    }

    protected void cut(FibonacciHeapNode<T> fibonacciHeapNode, FibonacciHeapNode<T> fibonacciHeapNode2) {
        fibonacciHeapNode.left.right = fibonacciHeapNode.right;
        fibonacciHeapNode.right.left = fibonacciHeapNode.left;
        --fibonacciHeapNode2.degree;
        if (fibonacciHeapNode2.child == fibonacciHeapNode) {
            fibonacciHeapNode2.child = fibonacciHeapNode.right;
        }
        if (fibonacciHeapNode2.degree == 0) {
            fibonacciHeapNode2.child = null;
        }
        fibonacciHeapNode.left = this.minNode;
        fibonacciHeapNode.right = this.minNode.right;
        this.minNode.right = fibonacciHeapNode;
        fibonacciHeapNode.right.left = fibonacciHeapNode;
        fibonacciHeapNode.parent = null;
        fibonacciHeapNode.mark = false;
    }

    protected void link(FibonacciHeapNode<T> fibonacciHeapNode, FibonacciHeapNode<T> fibonacciHeapNode2) {
        fibonacciHeapNode.left.right = fibonacciHeapNode.right;
        fibonacciHeapNode.right.left = fibonacciHeapNode.left;
        fibonacciHeapNode.parent = fibonacciHeapNode2;
        if (fibonacciHeapNode2.child == null) {
            fibonacciHeapNode2.child = fibonacciHeapNode;
            fibonacciHeapNode.right = fibonacciHeapNode;
            fibonacciHeapNode.left = fibonacciHeapNode;
        } else {
            fibonacciHeapNode.left = fibonacciHeapNode2.child;
            fibonacciHeapNode.right = fibonacciHeapNode2.child.right;
            fibonacciHeapNode2.child.right = fibonacciHeapNode;
            fibonacciHeapNode.right.left = fibonacciHeapNode;
        }
        ++fibonacciHeapNode2.degree;
        fibonacciHeapNode.mark = false;
    }
}

