/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.traverse;

import java.util.ArrayList;
import java.util.List;
import org.jgrapht.event.ConnectedComponentTraversalEvent;
import org.jgrapht.event.EdgeTraversalEvent;
import org.jgrapht.event.TraversalListener;
import org.jgrapht.event.VertexTraversalEvent;
import org.jgrapht.traverse.GraphIterator;

public abstract class AbstractGraphIterator<V, E>
implements GraphIterator<V, E> {
    private List<TraversalListener<V, E>> traversalListeners = new ArrayList<TraversalListener<V, E>>();
    private boolean crossComponentTraversal = true;
    private boolean reuseEvents = false;
    protected int nListeners = 0;

    public void setCrossComponentTraversal(boolean bl) {
        this.crossComponentTraversal = bl;
    }

    @Override
    public boolean isCrossComponentTraversal() {
        return this.crossComponentTraversal;
    }

    @Override
    public void setReuseEvents(boolean bl) {
        this.reuseEvents = bl;
    }

    @Override
    public boolean isReuseEvents() {
        return this.reuseEvents;
    }

    @Override
    public void addTraversalListener(TraversalListener<V, E> traversalListener) {
        if (!this.traversalListeners.contains(traversalListener)) {
            this.traversalListeners.add(traversalListener);
            this.nListeners = this.traversalListeners.size();
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeTraversalListener(TraversalListener<V, E> traversalListener) {
        this.traversalListeners.remove(traversalListener);
        this.nListeners = this.traversalListeners.size();
    }

    protected void fireConnectedComponentFinished(ConnectedComponentTraversalEvent connectedComponentTraversalEvent) {
        for (int i2 = 0; i2 < this.nListeners; ++i2) {
            TraversalListener<V, E> traversalListener = this.traversalListeners.get(i2);
            traversalListener.connectedComponentFinished(connectedComponentTraversalEvent);
        }
    }

    protected void fireConnectedComponentStarted(ConnectedComponentTraversalEvent connectedComponentTraversalEvent) {
        for (int i2 = 0; i2 < this.nListeners; ++i2) {
            TraversalListener<V, E> traversalListener = this.traversalListeners.get(i2);
            traversalListener.connectedComponentStarted(connectedComponentTraversalEvent);
        }
    }

    protected void fireEdgeTraversed(EdgeTraversalEvent<V, E> edgeTraversalEvent) {
        for (int i2 = 0; i2 < this.nListeners; ++i2) {
            TraversalListener<V, E> traversalListener = this.traversalListeners.get(i2);
            traversalListener.edgeTraversed(edgeTraversalEvent);
        }
    }

    protected void fireVertexTraversed(VertexTraversalEvent<V> vertexTraversalEvent) {
        for (int i2 = 0; i2 < this.nListeners; ++i2) {
            TraversalListener<V, E> traversalListener = this.traversalListeners.get(i2);
            traversalListener.vertexTraversed(vertexTraversalEvent);
        }
    }

    protected void fireVertexFinished(VertexTraversalEvent<V> vertexTraversalEvent) {
        for (int i2 = 0; i2 < this.nListeners; ++i2) {
            TraversalListener<V, E> traversalListener = this.traversalListeners.get(i2);
            traversalListener.vertexFinished(vertexTraversalEvent);
        }
    }
}

