/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.experimental.permutation;

import java.util.Arrays;
import java.util.Iterator;
import org.jgrapht.experimental.permutation.ArrayPermutationsIter;
import org.jgrapht.experimental.permutation.IntegerPermutationIter;
import org.jgrapht.util.MathUtil;

public class CompoundPermutationIter
implements ArrayPermutationsIter,
Iterator {
    IntegerPermutationIter[] permArray;
    private int totalPermArraySize;
    private int max;
    private int iterCounter = 0;

    public CompoundPermutationIter(int[] nArray) {
        this.init(nArray);
    }

    private void init(int[] nArray) {
        this.permArray = new IntegerPermutationIter[nArray.length];
        int n2 = 0;
        this.max = 1;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n3 = nArray[i2];
            int[] nArray2 = new int[n3];
            for (int i3 = 0; i3 < n3; ++i3) {
                nArray2[i3] = n2++;
            }
            this.permArray[i2] = new IntegerPermutationIter(nArray2);
            this.permArray[i2].getNext();
            this.max = (int)((long)this.max * MathUtil.factorial(n3));
        }
        this.totalPermArraySize = n2;
    }

    public Object next() {
        return this.getNext();
    }

    public int[] getNext() {
        Object object;
        if (this.iterCounter == 0) {
            ++this.iterCounter;
            return this.getPermAsArray();
        }
        int n2 = -1;
        int n3 = 0;
        while (n2 == -1) {
            object = this.permArray[n3];
            if (((IntegerPermutationIter)object).hasNext()) {
                ((IntegerPermutationIter)object).getNext();
                for (int i2 = 0; i2 < n3; ++i2) {
                    this.restartPermutationGroup(i2);
                }
                n2 = n3;
            }
            if (++n3 < this.permArray.length) continue;
            break;
        }
        ++this.iterCounter;
        if (n2 == -1) {
            return null;
        }
        object = this.getPermAsArray();
        return object;
    }

    public int[] getPermAsArray() {
        int[] nArray = new int[this.totalPermArraySize];
        int n2 = 0;
        for (int i2 = 0; i2 < this.permArray.length; ++i2) {
            int[] nArray2 = this.permArray[i2].getCurrent();
            System.arraycopy(nArray2, 0, nArray, n2, nArray2.length);
            n2 += nArray2.length;
        }
        return nArray;
    }

    private void restartPermutationGroup(int n2) {
        int[] nArray = this.permArray[n2].getCurrent();
        Arrays.sort(nArray);
        this.permArray[n2] = new IntegerPermutationIter(nArray);
        this.permArray[n2].getNext();
    }

    @Override
    public boolean hasNext() {
        boolean bl = this.iterCounter < this.max;
        return bl;
    }

    public int getMax() {
        return this.max;
    }

    @Override
    public int[] nextPermutation() {
        return (int[])this.next();
    }

    @Override
    public boolean hasNextPermutaions() {
        return this.hasNext();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

