/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.experimental;

import java.util.Arrays;
import java.util.Map;
import org.jgrapht.Graph;
import org.jgrapht.VertexFactory;
import org.jgrapht.experimental.RandomGraphHelper;
import org.jgrapht.generate.GraphGenerator;

public class PartiteRandomGraphGenerator<V, E>
implements GraphGenerator<V, E, Object[]> {
    private final int[] numVertices;
    private final int numEdges;

    public PartiteRandomGraphGenerator(int n2, int n3, int n4) {
        if (n2 < 0 || n3 < 0) {
            throw new IllegalArgumentException("must be non-negative");
        }
        if (n4 < 0 || n4 > n2 * n3) {
            throw new IllegalArgumentException("illegal number of edges");
        }
        int[] nArray = new int[]{n2, n3};
        this.numVertices = nArray;
        this.numEdges = n4;
    }

    public PartiteRandomGraphGenerator(int[] nArray, int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("illegal number of edges");
        }
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (nArray[i2] < 0) {
                throw new IllegalArgumentException("must be non-negative");
            }
            for (int i3 = 0; i3 < i2; ++i3) {
                if (n2 <= nArray[i2] * nArray[i3]) continue;
                throw new IllegalArgumentException("illegal number of edges");
            }
        }
        this.numVertices = nArray;
        this.numEdges = n2;
    }

    @Override
    public void generateGraph(Graph<V, E> graph, VertexFactory<V> vertexFactory, Map<String, Object[]> map) {
        Object[][] objectArrayArray = new Object[this.numVertices.length][];
        for (int i2 = 0; i2 < this.numVertices.length; ++i2) {
            objectArrayArray[i2] = RandomGraphHelper.addVertices(graph, vertexFactory, this.numVertices[i2]);
            if (map != null) {
                map.put(Integer.toString(i2), objectArrayArray[i2]);
            }
            for (int i3 = 0; i3 < i2; ++i3) {
                RandomGraphHelper.addEdges(graph, Arrays.asList(objectArrayArray[i2]), Arrays.asList(objectArrayArray[i3]), this.numEdges);
            }
        }
    }
}

