/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.UndirectedGraph;
import org.jgrapht.alg.BellmanFordPathElement;

class BellmanFordIterator<V, E>
implements Iterator<List<V>> {
    protected static final String NEGATIVE_UNDIRECTED_EDGE = "Negativeedge-weights are not allowed in an unidrected graph!";
    protected Graph<V, E> graph;
    protected V startVertex;
    private List<V> prevImprovedVertices = new ArrayList<V>();
    private Map<V, BellmanFordPathElement<V, E>> prevVertexData;
    private boolean startVertexEncountered = false;
    private Map<V, BellmanFordPathElement<V, E>> vertexData;
    private double epsilon;

    protected BellmanFordIterator(Graph<V, E> graph, V v2, double d2) {
        this.assertBellmanFordIterator(graph, v2);
        this.graph = graph;
        this.startVertex = v2;
        this.epsilon = d2;
    }

    public BellmanFordPathElement<V, E> getPathElement(V v2) {
        return this.getSeenData(v2);
    }

    @Override
    public boolean hasNext() {
        if (!this.startVertexEncountered) {
            this.encounterStartVertex();
        }
        return !this.prevImprovedVertices.isEmpty();
    }

    @Override
    public List<V> next() {
        if (!this.startVertexEncountered) {
            this.encounterStartVertex();
        }
        if (this.hasNext()) {
            ArrayList<V> arrayList = new ArrayList<V>();
            for (int i2 = this.prevImprovedVertices.size() - 1; i2 >= 0; --i2) {
                V v2 = this.prevImprovedVertices.get(i2);
                Iterator<E> iterator = this.edgesOfIterator(v2);
                while (iterator.hasNext()) {
                    E e2 = iterator.next();
                    V v3 = Graphs.getOppositeVertex(this.graph, e2, v2);
                    if (this.getPathElement(v3) != null) {
                        boolean bl = this.relaxVertexAgain(v3, e2);
                        if (!bl) continue;
                        arrayList.add(v3);
                        continue;
                    }
                    this.relaxVertex(v3, e2);
                    arrayList.add(v3);
                }
            }
            this.savePassData(arrayList);
            return arrayList;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    protected void assertValidEdge(E e2) {
        if (this.graph instanceof UndirectedGraph && this.graph.getEdgeWeight(e2) < 0.0) {
            throw new IllegalArgumentException(NEGATIVE_UNDIRECTED_EDGE);
        }
    }

    protected double calculatePathCost(V v2, E e2) {
        V v3 = Graphs.getOppositeVertex(this.graph, e2, v2);
        BellmanFordPathElement<V, E> bellmanFordPathElement = this.getPrevSeenData(v3);
        double d2 = this.graph.getEdgeWeight(e2);
        if (!bellmanFordPathElement.getVertex().equals(this.startVertex)) {
            d2 += bellmanFordPathElement.getCost();
        }
        return d2;
    }

    protected Iterator<E> edgesOfIterator(V v2) {
        if (this.graph instanceof DirectedGraph) {
            return ((DirectedGraph)this.graph).outgoingEdgesOf(v2).iterator();
        }
        return this.graph.edgesOf(v2).iterator();
    }

    protected BellmanFordPathElement<V, E> getPrevSeenData(V v2) {
        return this.prevVertexData.get(v2);
    }

    protected BellmanFordPathElement<V, E> getSeenData(V v2) {
        return this.vertexData.get(v2);
    }

    protected boolean isSeenVertex(V v2) {
        return this.vertexData.containsKey(v2);
    }

    protected BellmanFordPathElement<V, E> putPrevSeenData(V v2, BellmanFordPathElement<V, E> bellmanFordPathElement) {
        if (this.prevVertexData == null) {
            this.prevVertexData = new HashMap<V, BellmanFordPathElement<V, E>>();
        }
        return this.prevVertexData.put((BellmanFordPathElement<V, E>)v2, (BellmanFordPathElement<BellmanFordPathElement<V, E>, E>)bellmanFordPathElement);
    }

    protected BellmanFordPathElement<V, E> putSeenData(V v2, BellmanFordPathElement<V, E> bellmanFordPathElement) {
        if (this.vertexData == null) {
            this.vertexData = new HashMap<V, BellmanFordPathElement<V, E>>();
        }
        return this.vertexData.put((BellmanFordPathElement<V, E>)v2, (BellmanFordPathElement<BellmanFordPathElement<V, E>, E>)bellmanFordPathElement);
    }

    private void assertBellmanFordIterator(Graph<V, E> graph, V v2) {
        if (!graph.containsVertex(v2)) {
            throw new IllegalArgumentException("Graph must contain the start vertex!");
        }
    }

    private BellmanFordPathElement<V, E> createSeenData(V v2, E e2, double d2) {
        BellmanFordPathElement<V, E> bellmanFordPathElement = this.getPrevSeenData(Graphs.getOppositeVertex(this.graph, e2, v2));
        BellmanFordPathElement<V, E> bellmanFordPathElement2 = new BellmanFordPathElement<V, E>(this.graph, bellmanFordPathElement, e2, d2, this.epsilon);
        return bellmanFordPathElement2;
    }

    private void encounterStartVertex() {
        BellmanFordPathElement bellmanFordPathElement = new BellmanFordPathElement(this.startVertex, this.epsilon);
        this.prevImprovedVertices.add(this.startVertex);
        this.putSeenData(this.startVertex, bellmanFordPathElement);
        this.putPrevSeenData(this.startVertex, bellmanFordPathElement);
        this.startVertexEncountered = true;
    }

    private void relaxVertex(V v2, E e2) {
        this.assertValidEdge(e2);
        double d2 = this.calculatePathCost(v2, e2);
        BellmanFordPathElement<V, E> bellmanFordPathElement = this.createSeenData(v2, e2, d2);
        this.putSeenData(v2, bellmanFordPathElement);
    }

    private boolean relaxVertexAgain(V v2, E e2) {
        this.assertValidEdge(e2);
        double d2 = this.calculatePathCost(v2, e2);
        BellmanFordPathElement<V, E> bellmanFordPathElement = this.getPrevSeenData(Graphs.getOppositeVertex(this.graph, e2, v2));
        BellmanFordPathElement<V, E> bellmanFordPathElement2 = this.getSeenData(v2);
        return bellmanFordPathElement2.improve(bellmanFordPathElement, e2, d2);
    }

    private void savePassData(List<V> list) {
        for (V v2 : list) {
            BellmanFordPathElement<V, E> bellmanFordPathElement = this.getSeenData(v2);
            BellmanFordPathElement<V, E> bellmanFordPathElement2 = new BellmanFordPathElement<V, E>(bellmanFordPathElement);
            this.putPrevSeenData(v2, bellmanFordPathElement2);
        }
        this.prevImprovedVertices = list;
    }
}

