/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.tools.walkers.na12878kb.core;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Random;
import org.broadinstitute.gatk.tools.walkers.na12878kb.core.MongoDBManager;
import org.broadinstitute.gatk.utils.commandline.Argument;
import org.broadinstitute.gatk.utils.exceptions.GATKException;

public class NA12878DBArgumentCollection {
    public static final String DEFAULT_SPEC_PATH = "resources/NA12878kb.json";
    public static final String LOCALHOST_SPEC_PATH = "resources/NA12878kb_local.json";
    @Argument(fullName="useLocal", shortName="useLocal", doc="If true, the localhost MongoDB will be used; for testing only", required=false)
    protected boolean useLocal = false;
    String dbSpecPath = null;
    @Argument(fullName="dbToUse", shortName="dbToUse", doc="Which database should we connect to?", required=false)
    public DBType dbToUse = DBType.DEFAULT;
    @Argument(shortName="reset", required=false)
    public boolean resetDB = false;

    public MongoDBManager.Locator getLocator() {
        if (this.dbSpecPath == null) {
            this.dbSpecPath = NA12878DBArgumentCollection.getDBSpecPath(this.useLocal);
        }
        InputStream is = this.getInputStream(this.dbSpecPath);
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        String jsonString = "";
        String nextLine = null;
        try {
            while ((nextLine = reader.readLine()) != null) {
                jsonString = jsonString + nextLine + "\n";
            }
            MongoDBManager.Locator tmpLocator = new Gson().fromJson(jsonString, MongoDBManager.Locator.class);
            String dbName = tmpLocator.name;
            if (tmpLocator.specVersion == null) {
                dbName = dbName + this.dbToUse.getExtension();
            }
            MongoDBManager.Locator locator = new MongoDBManager.Locator(tmpLocator.host, tmpLocator.port, dbName, tmpLocator.sitesCollection, tmpLocator.callsetsCollection, tmpLocator.consensusCollection, tmpLocator.label, tmpLocator.specVersion);
            return locator;
        }
        catch (IOException e2) {
            throw new RuntimeException("Failure while reading json file " + this.dbSpecPath, e2);
        }
        catch (JsonParseException e3) {
            throw new RuntimeException("Failure parsing jsonString: " + e3.getMessage() + "\n" + jsonString, e3);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e4) {
                throw new RuntimeException("Failed to close json reader for " + this.dbSpecPath, e4);
            }
        }
    }

    private InputStream getInputStream(String specPath) throws GATKException {
        InputStream is = this.getClass().getResourceAsStream(specPath);
        if (is != null) {
            return is;
        }
        if (specPath.toLowerCase().startsWith("http")) {
            try {
                URL url = new URL(specPath);
                URLConnection conn = url.openConnection();
                if (conn instanceof HttpURLConnection) {
                    ((HttpURLConnection)conn).setInstanceFollowRedirects(true);
                }
                return conn.getInputStream();
            }
            catch (MalformedURLException e2) {
                throw new GATKException("Malformed url for db spec path", e2);
            }
            catch (IOException e3) {
                throw new GATKException("Error opening db spec", e3);
            }
        }
        try {
            return new FileInputStream(specPath);
        }
        catch (FileNotFoundException e4) {
            throw new GATKException("db spec path not found", e4);
        }
    }

    public NA12878DBArgumentCollection() {
        this(false);
    }

    private static String getDBSpecPath(boolean useLocal) {
        return useLocal ? LOCALHOST_SPEC_PATH : DEFAULT_SPEC_PATH;
    }

    public NA12878DBArgumentCollection(boolean useLocal) {
        this.useLocal = useLocal;
    }

    public NA12878DBArgumentCollection(String dbSpecPath) {
        this(dbSpecPath, DBType.PRODUCTION);
    }

    public NA12878DBArgumentCollection(String dbSpecPath, DBType dbToUse) {
        this.dbSpecPath = dbSpecPath;
        this.dbToUse = dbToUse;
    }

    public static enum DBType {
        PRODUCTION("_production"),
        DEV("_development"),
        TEST("_test"),
        DEFAULT("_NA"),
        BLANK("");

        private String extension;
        private static final Random rand;

        private DBType(String extension) {
            this.extension = extension;
        }

        public String getExtension() {
            return this.extension.equals("_test") ? String.format("%s_%d_%d", this.extension, System.currentTimeMillis(), rand.nextInt()) : this.extension;
        }

        static {
            rand = new Random();
        }
    }
}

