/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.tools.converters;

import htsjdk.samtools.util.SortingCollection;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Comparator;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.data.expression.ExpressionFileParser;
import org.broad.igv.data.expression.GeneToLocusHelper;
import org.broad.igv.feature.Locus;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.tools.sort.SortableRecord;
import org.broad.igv.tools.sort.SortableRecordCodec;
import org.broad.igv.track.TrackType;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;

public class GCTtoIGVConverter {
    private static Logger log = Logger.getLogger(GCTtoIGVConverter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convert(ResourceLocator resourceLocator, File outputFile, String probeResource, int maxRecords, File tmpDir, Genome genome) throws IOException {
        ExpressionFileParser.FileType type = ExpressionFileParser.determineType(resourceLocator);
        GeneToLocusHelper locusHelper = new GeneToLocusHelper(probeResource);
        BufferedReader reader = null;
        PrintWriter writer = null;
        SortingCollection cltn = GCTtoIGVConverter.getSortingCollection(maxRecords, tmpDir);
        try {
            reader = new BufferedReader(new InputStreamReader(ParsingUtils.openInputStream(resourceLocator.getPath())));
            writer = new PrintWriter(new BufferedWriter(new FileWriter(outputFile)));
            ExpressionFileParser.FormatDescriptor formatDescriptor = ExpressionFileParser.parseHeader(reader, type, null);
            String[] dataHeadings = formatDescriptor.getDataHeaders();
            String dataType = resourceLocator.getPath().contains("methylation") ? TrackType.DNA_METHYLATION.toString() : TrackType.GENE_EXPRESSION.toString();
            writer.println("#type=" + dataType);
            writer.print("Chr\tStart\tEnd\tProbe");
            for (String s2 : dataHeadings) {
                writer.print("\t" + s2);
            }
            writer.println();
            String nextLine = null;
            while ((nextLine = reader.readLine()) != null) {
                DataRow row = new DataRow(nextLine, formatDescriptor);
                String probe = row.getProbe();
                List<Locus> loci = locusHelper.getLoci(probe, row.getDescription(), genome.getId());
                if (loci == null || loci.isEmpty()) {
                    log.warn("No locus found for: " + probe + "  " + row.getDescription());
                    continue;
                }
                for (Locus locus : loci) {
                    String igvLine = locus.getChr() + "\t" + locus.getStart() + "\t" + locus.getEnd() + "\t" + probe + "\t" + row.getData();
                    cltn.add(new SortableRecord(locus.getChr(), locus.getStart(), igvLine));
                }
            }
            for (SortableRecord al : cltn) {
                writer.println(al.getText());
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
    }

    static SortingCollection getSortingCollection(int maxRecords, File tmpDir) {
        SortableRecordCodec codec = new SortableRecordCodec();
        Comparator<SortableRecord> comp = new Comparator<SortableRecord>(){

            @Override
            public int compare(SortableRecord o1, SortableRecord o2) {
                String chr1 = o1.getChromosome().replaceFirst("chr", "");
                String chr2 = o2.getChromosome().replaceFirst("chr", "");
                int s1 = Integer.MAX_VALUE;
                try {
                    s1 = Integer.parseInt(chr1);
                }
                catch (Exception e2) {
                    // empty catch block
                }
                int s2 = Integer.MAX_VALUE;
                try {
                    s2 = Integer.parseInt(chr2);
                }
                catch (Exception e3) {
                    // empty catch block
                }
                int t1 = s1 - s2;
                if (t1 == 0) {
                    chr1 = chr1.replace("M", "Z");
                    chr2 = chr2.replace("M", "Z");
                    t1 = chr1.compareTo(chr2);
                }
                if (t1 == 0) {
                    return o1.getStart() - o2.getStart();
                }
                return t1;
            }
        };
        return SortingCollection.newInstance(SortableRecord.class, codec, comp, maxRecords, tmpDir);
    }

    static class DataRow {
        private String probe;
        private String description;
        private String data;

        DataRow(String string, ExpressionFileParser.FormatDescriptor formatDescriptor) {
            String[] tokens = string.split("\t");
            this.probe = tokens[formatDescriptor.getProbeColumn()];
            int descriptionColumn = formatDescriptor.getDescriptionColumn();
            this.description = descriptionColumn < 0 ? "" : tokens[descriptionColumn];
            StringBuffer dataBuffer = new StringBuffer();
            int[] dataColumns = formatDescriptor.getDataColumns();
            dataBuffer.append(tokens[dataColumns[0]]);
            for (int i2 = 1; i2 < dataColumns.length; ++i2) {
                dataBuffer.append('\t');
                dataBuffer.append(tokens[dataColumns[i2]]);
            }
            this.data = dataBuffer.toString();
        }

        private String getProbe() {
            return this.probe;
        }

        public String getDescription() {
            return this.description;
        }

        public String getData() {
            return this.data;
        }
    }
}

