/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.plugin.mongocollab;

import com.mongodb.DBCollection;
import htsjdk.tribble.Feature;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.JMenuItem;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.plugin.mongocollab.DBFeature;
import org.broad.igv.plugin.mongocollab.FeatureAnnotDialog;
import org.broad.igv.plugin.mongocollab.MongoFeatureSource;
import org.broad.igv.track.FeatureSource;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackClickEvent;
import org.broad.igv.track.TrackMenuUtils;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.action.SearchCommand;
import org.broad.igv.ui.panel.IGVPopupMenu;
import org.broad.igv.ui.panel.ReferenceFrame;

public class MongoFeatureTrack
extends FeatureTrack {
    public MongoFeatureTrack(String id, String name, MongoFeatureSource source) {
        super(id, name, (FeatureSource)source);
    }

    @Override
    public void dispose() {
        super.dispose();
        SearchCommand.unregisterNamedFeatureSearcher((MongoFeatureSource)this.source);
    }

    private JMenuItem createEditAnnotMenuEntry(TrackClickEvent te, final DBFeature.IGVFeat selFeat) {
        boolean hasFrame;
        ReferenceFrame frame = te.getFrame();
        boolean bl = hasFrame = frame != null;
        if (!hasFrame) {
            return null;
        }
        final boolean editing = selFeat != null;
        final String chr = editing ? selFeat.getChr() : frame.getChrName();
        final int start = editing ? selFeat.getStart() : (int)te.getChromosomePosition();
        final int end = editing ? selFeat.getEnd() : (int)Math.ceil(frame.getChromosomePosition(te.getMouseEvent().getX() + 1));
        String featDispName = editing && selFeat.getName() != null ? selFeat.getName() : "Feature";
        String name = editing ? "Edit " + featDispName : "Add annotation to " + this.getName();
        JMenuItem item = new JMenuItem(name);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                Feature feat = editing ? selFeat.getDBFeature() : new BasicFeature(chr, start, end);
                FeatureAnnotDialog dialog = new FeatureAnnotDialog(IGV.getMainFrame(), MongoFeatureTrack.this.getCollection(), feat);
                dialog.setVisible(true);
            }
        });
        return item;
    }

    private DBCollection getCollection() {
        return ((MongoFeatureSource)this.source).getCollection();
    }

    @Override
    public IGVPopupMenu getPopupMenu(TrackClickEvent te) {
        String title = this.getName();
        List<Track> tracks = Arrays.asList(this);
        IGVPopupMenu menu = TrackMenuUtils.getPopupMenu(tracks, title, te);
        Feature feat = this.getFeatureAtMousePosition(te);
        JMenuItem item = this.createEditAnnotMenuEntry(te, (DBFeature.IGVFeat)feat);
        if (item != null) {
            menu.add(item);
        }
        return menu;
    }
}

