/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.maf;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.broad.igv.maf.MAFTile;

public class MAFTileCodec {
    public void encode(MAFTile maTile, DataOutputStream os) {
        try {
            os.writeInt(maTile.start);
            os.writeInt(maTile.end);
            os.writeInt(maTile.alignedSequences.size());
            for (Map.Entry<String, MAFTile.MASequence> entry : maTile.alignedSequences.entrySet()) {
                os.writeUTF(entry.getKey());
                os.writeUTF(entry.getValue().bases);
            }
            os.writeInt(maTile.gapAdjustedIdx.length);
            for (int i2 = 0; i2 < maTile.gapAdjustedIdx.length; ++i2) {
                os.writeInt(maTile.gapAdjustedIdx[i2]);
            }
            os.flush();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public MAFTile decode(DataInputStream inputStream) {
        try {
            int start = inputStream.readInt();
            int end = inputStream.readInt();
            int sz = inputStream.readInt();
            if (sz == 0) {
                return new MAFTile(start, end);
            }
            HashMap<String, String> bases = new HashMap<String, String>(sz);
            for (int i2 = 0; i2 < sz; ++i2) {
                String speciesId = inputStream.readUTF();
                String b2 = inputStream.readUTF();
                bases.put(speciesId, b2);
            }
            sz = inputStream.readInt();
            int[] gapAdjustedCoordinates = new int[sz];
            for (int i3 = 0; i3 < sz; ++i3) {
                gapAdjustedCoordinates[i3] = inputStream.readInt();
            }
            return new MAFTile(start, end, bases, gapAdjustedCoordinates);
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return null;
        }
    }
}

