/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.tribble;

import htsjdk.tribble.AsciiFeatureCodec;
import htsjdk.tribble.Feature;
import htsjdk.tribble.exception.CodecLineParsingException;
import htsjdk.tribble.readers.LineIterator;
import org.broad.igv.Globals;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.tribble.FeatureFileHeader;
import org.broad.igv.track.TrackProperties;
import org.broad.igv.track.TrackType;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.collections.MultiMap;

public class REPMaskCodec
extends AsciiFeatureCodec<BasicFeature> {
    FeatureFileHeader header;
    Genome genome;

    public REPMaskCodec(Genome genome) {
        super(BasicFeature.class);
        this.genome = genome;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object readActualHeader(LineIterator reader) {
        this.header = new FeatureFileHeader();
        this.header.setTrackType(TrackType.REPMASK);
        int nLines = 0;
        try {
            while (reader.hasNext()) {
                String nextLine = reader.peek();
                if (!(nextLine.startsWith("#") || nextLine.startsWith("track") || nextLine.startsWith("browser"))) {
                    return this.header;
                }
                reader.next();
                ++nLines;
                if (nextLine.startsWith("#type")) {
                    String[] tokens = nextLine.split("=");
                    if (tokens.length <= 1) continue;
                    try {
                        this.header.setTrackType(TrackType.valueOf(tokens[1]));
                        continue;
                    }
                    catch (Exception e2) {
                        continue;
                    }
                }
                if (!nextLine.startsWith("track")) continue;
                TrackProperties tp = new TrackProperties();
                ParsingUtils.parseTrackLine(nextLine, tp);
                this.header.setTrackProperties(tp);
            }
            return this.header;
        }
        catch (Exception e3) {
            throw new CodecLineParsingException("Error parsing header: " + e3.getMessage(), e3);
        }
    }

    @Override
    public boolean canDecode(String path) {
        return true;
    }

    @Override
    public Feature decodeLoc(String line) {
        String[] tokens = Globals.singleTabMultiSpacePattern.split(line);
        if (tokens.length < 15) {
            return this.decodeLegacy(tokens);
        }
        String chr = this.genome == null ? tokens[5] : this.genome.getCanonicalChrName(tokens[5]);
        int start = Integer.parseInt(tokens[6]);
        int end = Integer.parseInt(tokens[7]);
        return new BasicFeature(chr, start, end);
    }

    @Override
    public BasicFeature decode(String nextLine) {
        int strand;
        if (nextLine.trim().length() == 0 || nextLine.startsWith("#")) {
            return null;
        }
        String[] tokens = Globals.singleTabMultiSpacePattern.split(nextLine);
        int tokenCount = tokens.length;
        if (tokenCount < 15) {
            return this.decodeLegacy(tokens);
        }
        String chr = this.genome == null ? tokens[5] : this.genome.getCanonicalChrName(tokens[5]);
        int start = Integer.parseInt(tokens[6]);
        int end = Integer.parseInt(tokens[7]);
        BasicFeature feature = new BasicFeature(chr, start, end);
        feature.setRepresentation(nextLine);
        String strandString = tokens[3].trim();
        int n2 = strand = strandString.length() == 0 ? 32 : (int)strandString.charAt(0);
        if (strand == 45) {
            feature.setStrand(Strand.NEGATIVE);
        } else if (strand == 43) {
            feature.setStrand(Strand.POSITIVE);
        } else {
            feature.setStrand(Strand.NONE);
        }
        String name = tokens[10];
        feature.setName(name);
        feature.setIdentifier(name);
        MultiMap<String, String> attributes = new MultiMap<String, String>();
        attributes.put("Smith Waterman score", tokens[1]);
        attributes.put("base mismatches per thousand", tokens[2]);
        attributes.put("bases deleted per thousand", tokens[3]);
        attributes.put("bases inserted per thousand", tokens[4]);
        attributes.put("repeat class", tokens[11]);
        attributes.put("repeat family", tokens[12]);
        attributes.put("repeat start", tokens[13]);
        attributes.put("repeat end", tokens[14]);
        feature.setAttributes(attributes);
        return feature;
    }

    public BasicFeature decodeLegacy(String[] tokens) {
        int tokenCount = tokens.length;
        if (tokenCount < 2) {
            return null;
        }
        String chr = this.genome == null ? tokens[0] : this.genome.getCanonicalChrName(tokens[0]);
        int start = Integer.parseInt(tokens[1]);
        int end = start + 1;
        if (tokenCount > 2) {
            end = Integer.parseInt(tokens[2]);
        }
        BasicFeature feature = new BasicFeature(chr, start, end);
        if (tokenCount > 3) {
            int strand;
            String strandString = tokens[3].trim();
            int n2 = strand = strandString.length() == 0 ? 32 : (int)strandString.charAt(0);
            if (strand == 45) {
                feature.setStrand(Strand.NEGATIVE);
            } else if (strand == 43) {
                feature.setStrand(Strand.POSITIVE);
            } else {
                feature.setStrand(Strand.NONE);
            }
        }
        if (tokenCount > 4) {
            String name = tokens[4].replaceAll("\"", "");
            feature.setName(name);
            feature.setIdentifier(name);
        }
        return feature;
    }
}

