/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.dsi;

import htsjdk.tribble.Feature;
import java.util.List;
import org.broad.igv.feature.dsi.DSIFeature;
import org.broad.igv.feature.dsi.DSIRenderer;
import org.broad.igv.track.FeatureSource;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.util.ResourceLocator;

public class DSITrack
extends FeatureTrack {
    public DSITrack(ResourceLocator locator, FeatureSource src) {
        super(locator, src);
        this.setRenderer(new DSIRenderer());
    }

    @Override
    public String getValueStringAt(String chr, double position, int y, ReferenceFrame frame) {
        List<Feature> allFeatures = this.getAllFeatureAt(position, y, frame);
        if (allFeatures == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        boolean firstFeature = true;
        int maxNumber = 10;
        int n2 = 1;
        for (Feature feature : allFeatures) {
            if (feature != null && feature instanceof DSIFeature) {
                if (!firstFeature) {
                    buf.append("<hr><br>");
                }
                DSIFeature igvFeature = (DSIFeature)feature;
                String vs = igvFeature.getValueString(position, null);
                buf.append(vs);
                firstFeature = false;
                if (n2 > maxNumber) {
                    buf.append("...");
                    break;
                }
            }
            ++n2;
        }
        return buf.toString();
    }
}

