/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.analysis.interpolation;

import org.apache.commons.math.analysis.interpolation.UnivariateRealInterpolator;
import org.apache.commons.math.analysis.polynomials.PolynomialFunction;
import org.apache.commons.math.analysis.polynomials.PolynomialSplineFunction;
import org.apache.commons.math.exception.DimensionMismatchException;
import org.apache.commons.math.exception.NumberIsTooSmallException;
import org.apache.commons.math.exception.util.Localizable;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.util.MathUtils;

public class LinearInterpolator
implements UnivariateRealInterpolator {
    public PolynomialSplineFunction interpolate(double[] x2, double[] y) {
        if (x2.length != y.length) {
            throw new DimensionMismatchException(x2.length, y.length);
        }
        if (x2.length < 2) {
            throw new NumberIsTooSmallException((Localizable)LocalizedFormats.NUMBER_OF_POINTS, (Number)x2.length, (Number)2, true);
        }
        int n2 = x2.length - 1;
        MathUtils.checkOrder(x2);
        double[] m2 = new double[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            m2[i2] = (y[i2 + 1] - y[i2]) / (x2[i2 + 1] - x2[i2]);
        }
        PolynomialFunction[] polynomials = new PolynomialFunction[n2];
        double[] coefficients = new double[2];
        for (int i3 = 0; i3 < n2; ++i3) {
            coefficients[0] = y[i3];
            coefficients[1] = m2[i3];
            polynomials[i3] = new PolynomialFunction(coefficients);
        }
        return new PolynomialSplineFunction(x2, polynomials);
    }
}

