/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.analysis.interpolation;

import org.apache.commons.math.DimensionMismatchException;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.analysis.BivariateRealFunction;
import org.apache.commons.math.analysis.interpolation.BicubicSplineFunction;
import org.apache.commons.math.exception.NoDataException;
import org.apache.commons.math.exception.OutOfRangeException;
import org.apache.commons.math.util.MathUtils;

public class BicubicSplineInterpolatingFunction
implements BivariateRealFunction {
    private static final double[][] AINV = new double[][]{{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {-3.0, 3.0, 0.0, 0.0, -2.0, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {2.0, -2.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -3.0, 3.0, 0.0, 0.0, -2.0, -1.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0, -2.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0}, {-3.0, 0.0, 3.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, -3.0, 0.0, 3.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.0, 0.0, -1.0, 0.0}, {9.0, -9.0, -9.0, 9.0, 6.0, 3.0, -6.0, -3.0, 6.0, -6.0, 3.0, -3.0, 4.0, 2.0, 2.0, 1.0}, {-6.0, 6.0, 6.0, -6.0, -3.0, -3.0, 3.0, 3.0, -4.0, 4.0, -2.0, 2.0, -2.0, -2.0, -1.0, -1.0}, {2.0, 0.0, -2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 2.0, 0.0, -2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0}, {-6.0, 6.0, 6.0, -6.0, -4.0, -2.0, 4.0, 2.0, -3.0, 3.0, -3.0, 3.0, -2.0, -1.0, -2.0, -1.0}, {4.0, -4.0, -4.0, 4.0, 2.0, 2.0, -2.0, -2.0, 2.0, -2.0, 2.0, -2.0, 1.0, 1.0, 1.0, 1.0}};
    private final double[] xval;
    private final double[] yval;
    private final BicubicSplineFunction[][] splines;
    private BivariateRealFunction[][][] partialDerivatives = null;

    public BicubicSplineInterpolatingFunction(double[] x2, double[] y, double[][] f2, double[][] dFdX, double[][] dFdY, double[][] d2FdXdY) throws DimensionMismatchException {
        int xLen = x2.length;
        int yLen = y.length;
        if (xLen == 0 || yLen == 0 || f2.length == 0 || f2[0].length == 0) {
            throw new NoDataException();
        }
        if (xLen != f2.length) {
            throw new DimensionMismatchException(xLen, f2.length);
        }
        if (xLen != dFdX.length) {
            throw new DimensionMismatchException(xLen, dFdX.length);
        }
        if (xLen != dFdY.length) {
            throw new DimensionMismatchException(xLen, dFdY.length);
        }
        if (xLen != d2FdXdY.length) {
            throw new DimensionMismatchException(xLen, d2FdXdY.length);
        }
        MathUtils.checkOrder(x2);
        MathUtils.checkOrder(y);
        this.xval = (double[])x2.clone();
        this.yval = (double[])y.clone();
        int lastI = xLen - 1;
        int lastJ = yLen - 1;
        this.splines = new BicubicSplineFunction[lastI][lastJ];
        for (int i2 = 0; i2 < lastI; ++i2) {
            if (f2[i2].length != yLen) {
                throw new DimensionMismatchException(f2[i2].length, yLen);
            }
            if (dFdX[i2].length != yLen) {
                throw new DimensionMismatchException(dFdX[i2].length, yLen);
            }
            if (dFdY[i2].length != yLen) {
                throw new DimensionMismatchException(dFdY[i2].length, yLen);
            }
            if (d2FdXdY[i2].length != yLen) {
                throw new DimensionMismatchException(d2FdXdY[i2].length, yLen);
            }
            int ip1 = i2 + 1;
            for (int j2 = 0; j2 < lastJ; ++j2) {
                int jp1 = j2 + 1;
                double[] beta = new double[]{f2[i2][j2], f2[ip1][j2], f2[i2][jp1], f2[ip1][jp1], dFdX[i2][j2], dFdX[ip1][j2], dFdX[i2][jp1], dFdX[ip1][jp1], dFdY[i2][j2], dFdY[ip1][j2], dFdY[i2][jp1], dFdY[ip1][jp1], d2FdXdY[i2][j2], d2FdXdY[ip1][j2], d2FdXdY[i2][jp1], d2FdXdY[ip1][jp1]};
                this.splines[i2][j2] = new BicubicSplineFunction(this.computeSplineCoefficients(beta));
            }
        }
    }

    public double value(double x2, double y) {
        int i2 = this.searchIndex(x2, this.xval);
        if (i2 == -1) {
            throw new OutOfRangeException(x2, (Number)this.xval[0], this.xval[this.xval.length - 1]);
        }
        int j2 = this.searchIndex(y, this.yval);
        if (j2 == -1) {
            throw new OutOfRangeException(y, (Number)this.yval[0], this.yval[this.yval.length - 1]);
        }
        double xN = (x2 - this.xval[i2]) / (this.xval[i2 + 1] - this.xval[i2]);
        double yN = (y - this.yval[j2]) / (this.yval[j2 + 1] - this.yval[j2]);
        return this.splines[i2][j2].value(xN, yN);
    }

    public double partialDerivativeX(double x2, double y) {
        return this.partialDerivative(0, x2, y);
    }

    public double partialDerivativeY(double x2, double y) {
        return this.partialDerivative(1, x2, y);
    }

    public double partialDerivativeXX(double x2, double y) {
        return this.partialDerivative(2, x2, y);
    }

    public double partialDerivativeYY(double x2, double y) {
        return this.partialDerivative(3, x2, y);
    }

    public double partialDerivativeXY(double x2, double y) {
        return this.partialDerivative(4, x2, y);
    }

    private double partialDerivative(int which, double x2, double y) {
        int i2;
        if (this.partialDerivatives == null) {
            this.computePartialDerivatives();
        }
        if ((i2 = this.searchIndex(x2, this.xval)) == -1) {
            throw new OutOfRangeException(x2, (Number)this.xval[0], this.xval[this.xval.length - 1]);
        }
        int j2 = this.searchIndex(y, this.yval);
        if (j2 == -1) {
            throw new OutOfRangeException(y, (Number)this.yval[0], this.yval[this.yval.length - 1]);
        }
        double xN = (x2 - this.xval[i2]) / (this.xval[i2 + 1] - this.xval[i2]);
        double yN = (y - this.yval[j2]) / (this.yval[j2 + 1] - this.yval[j2]);
        try {
            return this.partialDerivatives[which][i2][j2].value(xN, yN);
        }
        catch (FunctionEvaluationException fee) {
            throw new RuntimeException(fee);
        }
    }

    private void computePartialDerivatives() {
        int lastI = this.xval.length - 1;
        int lastJ = this.yval.length - 1;
        this.partialDerivatives = new BivariateRealFunction[5][lastI][lastJ];
        for (int i2 = 0; i2 < lastI; ++i2) {
            for (int j2 = 0; j2 < lastJ; ++j2) {
                BicubicSplineFunction f2 = this.splines[i2][j2];
                this.partialDerivatives[0][i2][j2] = f2.partialDerivativeX();
                this.partialDerivatives[1][i2][j2] = f2.partialDerivativeY();
                this.partialDerivatives[2][i2][j2] = f2.partialDerivativeXX();
                this.partialDerivatives[3][i2][j2] = f2.partialDerivativeYY();
                this.partialDerivatives[4][i2][j2] = f2.partialDerivativeXY();
            }
        }
    }

    private int searchIndex(double c2, double[] val) {
        if (c2 < val[0]) {
            return -1;
        }
        int max = val.length;
        for (int i2 = 1; i2 < max; ++i2) {
            if (!(c2 <= val[i2])) continue;
            return i2 - 1;
        }
        return -1;
    }

    private double[] computeSplineCoefficients(double[] beta) {
        double[] a2 = new double[16];
        for (int i2 = 0; i2 < 16; ++i2) {
            double result = 0.0;
            double[] row = AINV[i2];
            for (int j2 = 0; j2 < 16; ++j2) {
                result += row[j2] * beta[j2];
            }
            a2[i2] = result;
        }
        return a2;
    }
}

