/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.transcoder.image;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.SinglePixelPackedSampleModel;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.gvt.renderer.ConcreteImageRendererFactory;
import org.apache.batik.gvt.renderer.ImageRenderer;
import org.apache.batik.transcoder.SVGAbstractTranscoder;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.batik.transcoder.keys.BooleanKey;
import org.apache.batik.transcoder.keys.PaintKey;
import org.w3c.dom.Document;

public abstract class ImageTranscoder
extends SVGAbstractTranscoder {
    public static final TranscodingHints.Key KEY_BACKGROUND_COLOR = new PaintKey();
    public static final TranscodingHints.Key KEY_FORCE_TRANSPARENT_WHITE = new BooleanKey();

    protected ImageTranscoder() {
    }

    protected void transcode(Document document, String uri, TranscoderOutput output) throws TranscoderException {
        super.transcode(document, uri, output);
        int w2 = (int)((double)this.width + 0.5);
        int h2 = (int)((double)this.height + 0.5);
        ImageRenderer renderer = this.createRenderer();
        renderer.updateOffScreen(w2, h2);
        renderer.setTransform(this.curTxf);
        renderer.setTree(this.root);
        this.root = null;
        try {
            Rectangle2D.Float raoi = new Rectangle2D.Float(0.0f, 0.0f, this.width, this.height);
            renderer.repaint(this.curTxf.createInverse().createTransformedShape(raoi));
            BufferedImage rend = renderer.getOffScreen();
            renderer = null;
            BufferedImage dest = this.createImage(w2, h2);
            Graphics2D g2d = GraphicsUtil.createGraphics(dest);
            if (this.hints.containsKey(KEY_BACKGROUND_COLOR)) {
                Paint bgcolor = (Paint)this.hints.get(KEY_BACKGROUND_COLOR);
                g2d.setComposite(AlphaComposite.SrcOver);
                g2d.setPaint(bgcolor);
                g2d.fillRect(0, 0, w2, h2);
            }
            if (rend != null) {
                g2d.drawRenderedImage(rend, new AffineTransform());
            }
            g2d.dispose();
            rend = null;
            this.writeImage(dest, output);
        }
        catch (Exception ex) {
            throw new TranscoderException(ex);
        }
    }

    protected ImageRenderer createRenderer() {
        ConcreteImageRendererFactory rendFactory = new ConcreteImageRendererFactory();
        return rendFactory.createStaticImageRenderer();
    }

    protected void forceTransparentWhite(BufferedImage img, SinglePixelPackedSampleModel sppsm) {
        int w2 = img.getWidth();
        int h2 = img.getHeight();
        DataBufferInt biDB = (DataBufferInt)img.getRaster().getDataBuffer();
        int scanStride = sppsm.getScanlineStride();
        int dbOffset = biDB.getOffset();
        int[] pixels = biDB.getBankData()[0];
        int p2 = dbOffset;
        int adjust = scanStride - w2;
        int a2 = 0;
        int r2 = 0;
        int g2 = 0;
        int b2 = 0;
        int pel = 0;
        int i2 = 0;
        while (i2 < h2) {
            int j2 = 0;
            while (j2 < w2) {
                pel = pixels[p2];
                a2 = pel >> 24 & 0xFF;
                r2 = pel >> 16 & 0xFF;
                g2 = pel >> 8 & 0xFF;
                b2 = pel & 0xFF;
                r2 = (255 * (255 - a2) + a2 * r2) / 255;
                g2 = (255 * (255 - a2) + a2 * g2) / 255;
                b2 = (255 * (255 - a2) + a2 * b2) / 255;
                pixels[p2++] = a2 << 24 & 0xFF000000 | r2 << 16 & 0xFF0000 | g2 << 8 & 0xFF00 | b2 & 0xFF;
                ++j2;
            }
            p2 += adjust;
            ++i2;
        }
    }

    public abstract BufferedImage createImage(int var1, int var2);

    public abstract void writeImage(BufferedImage var1, TranscoderOutput var2) throws TranscoderException;
}

