/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.font;

import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;

public class AWTGlyphGeometryCache {
    protected static final int INITIAL_CAPACITY = 71;
    protected Entry[] table;
    protected int count;
    protected ReferenceQueue referenceQueue = new ReferenceQueue();

    public AWTGlyphGeometryCache() {
        this.table = new Entry[71];
    }

    public AWTGlyphGeometryCache(int c2) {
        this.table = new Entry[c2];
    }

    public int size() {
        return this.count;
    }

    public Value get(char c2) {
        int hash = this.hashCode(c2) & Integer.MAX_VALUE;
        int index = hash % this.table.length;
        Entry e2 = this.table[index];
        while (e2 != null) {
            if (e2.hash == hash && e2.match(c2)) {
                return (Value)e2.get();
            }
            e2 = e2.next;
        }
        return null;
    }

    public Value put(char c2, Value value) {
        int len;
        this.removeClearedEntries();
        int hash = this.hashCode(c2) & Integer.MAX_VALUE;
        int index = hash % this.table.length;
        Entry e2 = this.table[index];
        if (e2 != null) {
            if (e2.hash == hash && e2.match(c2)) {
                Object old = e2.get();
                this.table[index] = new Entry(hash, c2, value, e2.next);
                return (Value)old;
            }
            Entry o2 = e2;
            e2 = e2.next;
            while (e2 != null) {
                if (e2.hash == hash && e2.match(c2)) {
                    Object old = e2.get();
                    o2.next = e2 = new Entry(hash, c2, value, e2.next);
                    return (Value)old;
                }
                o2 = e2;
                e2 = e2.next;
            }
        }
        if (this.count++ >= (len = this.table.length) - (len >> 2)) {
            this.rehash();
            index = hash % this.table.length;
        }
        this.table[index] = new Entry(hash, c2, value, this.table[index]);
        return null;
    }

    public void clear() {
        this.table = new Entry[71];
        this.count = 0;
        this.referenceQueue = new ReferenceQueue();
    }

    protected void rehash() {
        Entry[] oldTable = this.table;
        this.table = new Entry[oldTable.length * 2 + 1];
        int i2 = oldTable.length - 1;
        while (i2 >= 0) {
            Entry old = oldTable[i2];
            while (old != null) {
                Entry e2 = old;
                old = old.next;
                int index = e2.hash % this.table.length;
                e2.next = this.table[index];
                this.table[index] = e2;
            }
            --i2;
        }
    }

    protected int hashCode(char c2) {
        return c2;
    }

    /*
     * Unable to fully structure code
     */
    protected void removeClearedEntries() {
        while ((e = (Entry)this.referenceQueue.poll()) != null) {
            block3: {
                index = var1_1.hash % this.table.length;
                t = this.table[index];
                if (t != var1_1) ** GOTO lbl12
                this.table[index] = var1_1.next;
                break block3;
lbl-1000:
                // 1 sources

                {
                    c = t.next;
                    if (c == var1_1) {
                        t.next = var1_1.next;
                        break;
                    }
                    t = c;
lbl12:
                    // 2 sources

                    ** while (t != null)
                }
            }
            --this.count;
        }
    }

    protected class Entry
    extends SoftReference {
        public int hash;
        public char c;
        public Entry next;

        public Entry(int hash, char c2, Value value, Entry next) {
            super(value, AWTGlyphGeometryCache.this.referenceQueue);
            this.hash = hash;
            this.c = c2;
            this.next = next;
        }

        public boolean match(char o2) {
            return this.c == o2;
        }
    }

    public static class Value {
        protected Shape outline;
        protected Rectangle2D gmB;
        protected Rectangle2D outlineBounds;

        public Value(Shape outline, Rectangle2D gmB) {
            this.outline = outline;
            this.outlineBounds = outline.getBounds2D();
            this.gmB = gmB;
        }

        public Shape getOutline() {
            return this.outline;
        }

        public Rectangle2D getBounds2D() {
            return this.gmB;
        }

        public Rectangle2D getOutlineBounds2D() {
            return this.outlineBounds;
        }
    }
}

