/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import org.apache.batik.bridge.AnimatableGenericSVGBridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.ErrorConstants;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.gvt.text.TextPath;
import org.apache.batik.parser.AWTPathProducer;
import org.apache.batik.parser.ParseException;
import org.apache.batik.parser.PathParser;
import org.apache.batik.parser.UnitProcessor;
import org.w3c.dom.Element;

public class SVGTextPathElementBridge
extends AnimatableGenericSVGBridge
implements ErrorConstants {
    public String getLocalName() {
        return "textPath";
    }

    public void handleElement(BridgeContext ctx, Element e2) {
    }

    public TextPath createTextPath(BridgeContext ctx, Element textPathElement) {
        Shape pathShape;
        String s2;
        Element pathElement;
        block13: {
            String uri = XLinkSupport.getXLinkHref(textPathElement);
            pathElement = ctx.getReferencedElement(textPathElement, uri);
            if (pathElement == null || !"http://www.w3.org/2000/svg".equals(pathElement.getNamespaceURI()) || !pathElement.getLocalName().equals("path")) {
                throw new BridgeException(ctx, textPathElement, "uri.badTarget", new Object[]{uri});
            }
            s2 = pathElement.getAttributeNS(null, "d");
            pathShape = null;
            if (s2.length() != 0) {
                AWTPathProducer app = new AWTPathProducer();
                app.setWindingRule(CSSUtilities.convertFillRule(pathElement));
                try {
                    try {
                        PathParser pathParser = new PathParser();
                        pathParser.setPathHandler(app);
                        pathParser.parse(s2);
                    }
                    catch (ParseException pEx) {
                        throw new BridgeException(ctx, pathElement, pEx, "attribute.malformed", new Object[]{"d"});
                    }
                    Object var10_11 = null;
                    pathShape = app.getShape();
                    break block13;
                }
                catch (Throwable throwable) {
                    Object var10_12 = null;
                    pathShape = app.getShape();
                    throw throwable;
                }
            }
            throw new BridgeException(ctx, pathElement, "attribute.missing", new Object[]{"d"});
        }
        s2 = pathElement.getAttributeNS(null, "transform");
        if (s2.length() != 0) {
            AffineTransform tr = SVGUtilities.convertTransform(pathElement, "transform", s2, ctx);
            pathShape = tr.createTransformedShape(pathShape);
        }
        TextPath textPath = new TextPath(new GeneralPath(pathShape));
        s2 = textPathElement.getAttributeNS(null, "startOffset");
        if (s2.length() > 0) {
            float startOffset = 0.0f;
            int percentIndex = s2.indexOf(37);
            if (percentIndex != -1) {
                float pathLength = textPath.lengthOfPath();
                String percentString = s2.substring(0, percentIndex);
                float startOffsetPercent = 0.0f;
                try {
                    startOffsetPercent = SVGUtilities.convertSVGNumber(percentString);
                }
                catch (NumberFormatException e2) {
                    startOffsetPercent = -1.0f;
                }
                if (startOffsetPercent < 0.0f) {
                    throw new BridgeException(ctx, textPathElement, "attribute.malformed", new Object[]{"startOffset", s2});
                }
                startOffset = (float)((double)(startOffsetPercent * pathLength) / 100.0);
            } else {
                UnitProcessor.Context uctx = UnitProcessor.createContext(ctx, textPathElement);
                startOffset = UnitProcessor.svgOtherLengthToUserSpace(s2, "startOffset", uctx);
            }
            textPath.setStartOffset(startOffset);
        }
        return textPath;
    }
}

