/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.geom.Rectangle2D;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.batik.bridge.AbstractSVGFilterPrimitiveElementBridge;
import org.apache.batik.bridge.AnimatableGenericSVGBridge;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.ext.awt.image.ComponentTransferFunction;
import org.apache.batik.ext.awt.image.ConcreteComponentTransferFunction;
import org.apache.batik.ext.awt.image.PadMode;
import org.apache.batik.ext.awt.image.renderable.AbstractRable;
import org.apache.batik.ext.awt.image.renderable.ComponentTransferRable8Bit;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.PadRable8Bit;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SVGFeComponentTransferElementBridge
extends AbstractSVGFilterPrimitiveElementBridge {
    public String getLocalName() {
        return "feComponentTransfer";
    }

    public Filter createFilter(BridgeContext ctx, Element filterElement, Element filteredElement, GraphicsNode filteredNode, Filter inputFilter, Rectangle2D filterRegion, Map filterMap) {
        Filter in = AbstractSVGFilterPrimitiveElementBridge.getIn(filterElement, filteredElement, filteredNode, inputFilter, filterMap, ctx);
        if (in == null) {
            return null;
        }
        Rectangle2D defaultRegion = in.getBounds2D();
        Rectangle2D primitiveRegion = SVGUtilities.convertFilterPrimitiveRegion(filterElement, filteredElement, filteredNode, defaultRegion, filterRegion, ctx);
        ComponentTransferFunction funcR = null;
        ComponentTransferFunction funcG = null;
        ComponentTransferFunction funcB = null;
        ComponentTransferFunction funcA = null;
        Node n2 = filterElement.getFirstChild();
        while (n2 != null) {
            Element e2;
            Bridge bridge;
            if (n2.getNodeType() == 1 && (bridge = ctx.getBridge(e2 = (Element)n2)) != null && bridge instanceof SVGFeFuncElementBridge) {
                SVGFeFuncElementBridge funcBridge = (SVGFeFuncElementBridge)bridge;
                ComponentTransferFunction func = funcBridge.createComponentTransferFunction(filterElement, e2);
                if (funcBridge instanceof SVGFeFuncRElementBridge) {
                    funcR = func;
                } else if (funcBridge instanceof SVGFeFuncGElementBridge) {
                    funcG = func;
                } else if (funcBridge instanceof SVGFeFuncBElementBridge) {
                    funcB = func;
                } else if (funcBridge instanceof SVGFeFuncAElementBridge) {
                    funcA = func;
                }
            }
            n2 = n2.getNextSibling();
        }
        AbstractRable filter = new ComponentTransferRable8Bit(in, funcA, funcR, funcG, funcB);
        AbstractSVGFilterPrimitiveElementBridge.handleColorInterpolationFilters(filter, filterElement);
        filter = new PadRable8Bit(filter, primitiveRegion, PadMode.ZERO_PAD);
        AbstractSVGFilterPrimitiveElementBridge.updateFilterMap(filterElement, filter, filterMap);
        return filter;
    }

    protected static abstract class SVGFeFuncElementBridge
    extends AnimatableGenericSVGBridge {
        protected SVGFeFuncElementBridge() {
        }

        public ComponentTransferFunction createComponentTransferFunction(Element filterElement, Element funcElement) {
            int type = SVGFeFuncElementBridge.convertType(funcElement, this.ctx);
            switch (type) {
                case 2: {
                    float[] v2 = SVGFeFuncElementBridge.convertTableValues(funcElement, this.ctx);
                    if (v2 == null) {
                        return ConcreteComponentTransferFunction.getIdentityTransfer();
                    }
                    return ConcreteComponentTransferFunction.getDiscreteTransfer(v2);
                }
                case 0: {
                    return ConcreteComponentTransferFunction.getIdentityTransfer();
                }
                case 4: {
                    float amplitude = AbstractSVGFilterPrimitiveElementBridge.convertNumber(funcElement, "amplitude", 1.0f, this.ctx);
                    float exponent = AbstractSVGFilterPrimitiveElementBridge.convertNumber(funcElement, "exponent", 1.0f, this.ctx);
                    float offset = AbstractSVGFilterPrimitiveElementBridge.convertNumber(funcElement, "offset", 0.0f, this.ctx);
                    return ConcreteComponentTransferFunction.getGammaTransfer(amplitude, exponent, offset);
                }
                case 3: {
                    float slope = AbstractSVGFilterPrimitiveElementBridge.convertNumber(funcElement, "slope", 1.0f, this.ctx);
                    float intercept = AbstractSVGFilterPrimitiveElementBridge.convertNumber(funcElement, "intercept", 0.0f, this.ctx);
                    return ConcreteComponentTransferFunction.getLinearTransfer(slope, intercept);
                }
                case 1: {
                    float[] v3 = SVGFeFuncElementBridge.convertTableValues(funcElement, this.ctx);
                    if (v3 == null) {
                        return ConcreteComponentTransferFunction.getIdentityTransfer();
                    }
                    return ConcreteComponentTransferFunction.getTableTransfer(v3);
                }
            }
            throw new Error("invalid convertType:" + type);
        }

        protected static float[] convertTableValues(Element e2, BridgeContext ctx) {
            String s2 = e2.getAttributeNS(null, "tableValues");
            if (s2.length() == 0) {
                return null;
            }
            StringTokenizer tokens = new StringTokenizer(s2, " ,");
            float[] v2 = new float[tokens.countTokens()];
            try {
                int i2 = 0;
                while (tokens.hasMoreTokens()) {
                    v2[i2] = SVGUtilities.convertSVGNumber(tokens.nextToken());
                    ++i2;
                }
            }
            catch (NumberFormatException nfEx) {
                throw new BridgeException(ctx, e2, nfEx, "attribute.malformed", new Object[]{"tableValues", s2});
            }
            return v2;
        }

        protected static int convertType(Element e2, BridgeContext ctx) {
            String s2 = e2.getAttributeNS(null, "type");
            if (s2.length() == 0) {
                throw new BridgeException(ctx, e2, "attribute.missing", new Object[]{"type"});
            }
            if ("discrete".equals(s2)) {
                return 2;
            }
            if ("identity".equals(s2)) {
                return 0;
            }
            if ("gamma".equals(s2)) {
                return 4;
            }
            if ("linear".equals(s2)) {
                return 3;
            }
            if ("table".equals(s2)) {
                return 1;
            }
            throw new BridgeException(ctx, e2, "attribute.malformed", new Object[]{"type", s2});
        }
    }

    public static class SVGFeFuncBElementBridge
    extends SVGFeFuncElementBridge {
        public String getLocalName() {
            return "feFuncB";
        }
    }

    public static class SVGFeFuncGElementBridge
    extends SVGFeFuncElementBridge {
        public String getLocalName() {
            return "feFuncG";
        }
    }

    public static class SVGFeFuncRElementBridge
    extends SVGFeFuncElementBridge {
        public String getLocalName() {
            return "feFuncR";
        }
    }

    public static class SVGFeFuncAElementBridge
    extends SVGFeFuncElementBridge {
        public String getLocalName() {
            return "feFuncA";
        }
    }
}

