/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.huffman.codec;

import htsjdk.samtools.cram.encoding.AbstractBitCodec;
import htsjdk.samtools.cram.encoding.huffman.codec.HuffmanBitCode;
import htsjdk.samtools.cram.encoding.huffman.codec.HuffmanByteHelper;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;
import java.io.IOException;

class CanonicalHuffmanByteCodec
extends AbstractBitCodec<Byte> {
    private final HuffmanByteHelper helper;

    public CanonicalHuffmanByteCodec(byte[] values, int[] bitLengths) {
        this.helper = new HuffmanByteHelper(values, bitLengths);
    }

    @Override
    public Byte read(BitInputStream bitInputStream) throws IOException {
        return this.helper.read(bitInputStream);
    }

    @Override
    public long write(BitOutputStream bitOutputStream, Byte object) throws IOException {
        return this.helper.write(bitOutputStream, object);
    }

    @Override
    public long numberOfBits(Byte object) {
        try {
            HuffmanBitCode bitCode = this.helper.codes.get(object);
            return bitCode.bitLength;
        }
        catch (NullPointerException e2) {
            throw new RuntimeException("Value " + object + " not found.", e2);
        }
    }

    @Override
    public Byte read(BitInputStream bitInputStream, int length) throws IOException {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public void readInto(BitInputStream bitInputStream, byte[] array, int offset, int valueLen) throws IOException {
        for (int i2 = 0; i2 < valueLen; ++i2) {
            array[offset + i2] = this.helper.read(bitInputStream);
        }
    }
}

