/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent.misc;

import EDU.oswego.cs.dl.util.concurrent.Callable;
import EDU.oswego.cs.dl.util.concurrent.FutureResult;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactory;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactoryUser;
import EDU.oswego.cs.dl.util.concurrent.TimedCallable;
import EDU.oswego.cs.dl.util.concurrent.TimeoutException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;

public abstract class SwingWorker
extends ThreadFactoryUser
implements Runnable {
    private static final ThreadFactory FACTORY = new ThreadFactory(){

        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable);
            thread.setPriority(2);
            return thread;
        }
    };
    private final FutureResult result = new FutureResult();
    private final long timeout;
    private Thread thread;

    public SwingWorker() {
        this(FACTORY, 0L);
    }

    public SwingWorker(long l2) {
        this(FACTORY, l2);
    }

    protected SwingWorker(ThreadFactory threadFactory, long l2) {
        this.setThreadFactory(threadFactory);
        if (l2 < 0L) {
            throw new IllegalArgumentException("timeout=" + l2);
        }
        this.timeout = l2;
    }

    protected abstract Object construct() throws Exception;

    protected void finished() {
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void run() {
        Callable callable = new Callable(){

            public Object call() throws Exception {
                return SwingWorker.this.construct();
            }
        };
        Runnable runnable = new Runnable(){

            public void run() {
                SwingWorker.this.finished();
            }
        };
        long l2 = this.getTimeout();
        if (l2 != 0L) {
            TimedCallable timedCallable = new TimedCallable(callable, l2);
            timedCallable.setThreadFactory(this.getThreadFactory());
            callable = timedCallable;
        }
        this.result.setter(callable).run();
        SwingUtilities.invokeLater(runnable);
    }

    public synchronized void start() {
        if (this.thread == null) {
            this.thread = this.getThreadFactory().newThread(this);
        }
        this.thread.start();
    }

    public synchronized void interrupt() {
        if (this.thread != null) {
            try {
                this.thread.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.result.setException(new InterruptedException());
    }

    public Object get() throws InterruptedException, InvocationTargetException {
        return this.result.get();
    }

    public Object timedGet(long l2) throws TimeoutException, InterruptedException, InvocationTargetException {
        return this.result.timedGet(l2);
    }

    public InvocationTargetException getException() {
        return this.result.getException();
    }

    public boolean isReady() {
        return this.result.isReady();
    }
}

