/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class AutoResizingTextArea
extends JTextArea {
    public static final int DEFAULT_MAX_ROWS = 20;
    public static final int DEFAULT_MIN_ROWS = 1;
    private int _maxRows;
    private int _minRows;
    private ResizingDocumentListener _listener;

    public AutoResizingTextArea() {
        this(1, 20);
    }

    public AutoResizingTextArea(int minRows) {
        this(minRows, 20);
    }

    public AutoResizingTextArea(int minRows, int maxRows) {
        this.setMinRows(minRows);
        this.setMaxRows(maxRows);
        this.setRows(minRows);
    }

    public AutoResizingTextArea(String text) {
        this();
        this.setText(text);
    }

    public AutoResizingTextArea(int minRows, int maxRows, int columns) {
        this(minRows, maxRows);
        this.setMinRows(minRows);
        this.setMaxRows(maxRows);
        this.setColumns(columns);
    }

    public AutoResizingTextArea(String text, int minRows, int maxRows, int columns) {
        this(minRows, maxRows, columns);
        this.setText(text);
    }

    public AutoResizingTextArea(Document doc) {
        this();
        this.setDocument(doc);
    }

    public AutoResizingTextArea(Document doc, String text, int minRows, int maxRows, int columns) {
        super(doc, text, minRows, columns);
        this.setMaxRows(maxRows);
        this.setMinRows(minRows);
    }

    public void setRows(int rows) {
        int oldRow = super.getRows();
        int newRow = this.clipRowCount(rows);
        super.setRows(newRow);
        this.numberOfRowsUpdated(oldRow, newRow);
    }

    protected void numberOfRowsUpdated(int oldRow, int newRow) {
        Container parent;
        JScrollPane scroll = this.getParentScrollPane();
        if (scroll != null && (parent = scroll.getParent()) != null && parent instanceof JComponent) {
            JComponent component = (JComponent)parent;
            component.revalidate();
        }
    }

    public int getMaxRows() {
        return this._maxRows;
    }

    public void setMaxRows(int maxRows) {
        this._maxRows = maxRows;
        this.setRows(this.clipRowCount(this.getRows()));
    }

    public int getMinRows() {
        return this._minRows;
    }

    public void setMinRows(int minRows) {
        this._minRows = minRows;
        this.setRows(this.clipRowCount(this.getRows()));
    }

    public void setDocument(Document doc) {
        Document document = this.getDocument();
        if (document != null && this._listener != null) {
            document.removeDocumentListener(this._listener);
        }
        super.setDocument(doc);
        if (doc != null) {
            if (this._listener == null) {
                this._listener = new ResizingDocumentListener();
            }
            doc.addDocumentListener(this._listener);
        }
        this.updateSize();
    }

    private int clipRowCount(int rows) {
        int r = Math.min(this._maxRows, rows);
        r = Math.max(this._minRows, r);
        return r;
    }

    private int getHeight(int rows) {
        Insets insets = this.getInsets();
        return rows * this.getRowHeight() + insets.top + insets.bottom;
    }

    private void updateSize() {
        JScrollPane parent = this.getParentScrollPane();
        if (parent != null && parent.getParent() instanceof JComponent) {
            JComponent component = (JComponent)parent.getParent();
            component.revalidate();
        }
    }

    public Dimension getPreferredScrollableViewportSize() {
        Dimension size = this.getPreferredSize();
        if (this.getMinRows() != 0 && this.getMaxRows() != 0) {
            size.height = Math.max(this.getHeight(this.getMinRows()), Math.min(this.getHeight(this.getMaxRows()), size.height));
        }
        return size;
    }

    private JScrollPane getParentScrollPane() {
        Container parent = this.getParent();
        if (parent != null && parent instanceof JViewport) {
            return (JScrollPane)parent.getParent();
        }
        return null;
    }

    private class ResizingDocumentListener
    implements DocumentListener {
        private ResizingDocumentListener() {
        }

        public void insertUpdate(DocumentEvent e) {
            AutoResizingTextArea.this.updateSize();
        }

        public void removeUpdate(DocumentEvent e) {
            AutoResizingTextArea.this.updateSize();
        }

        public void changedUpdate(DocumentEvent e) {
            AutoResizingTextArea.this.updateSize();
        }
    }
}

