/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.Bytes;
import com.mongodb.CommandResult;
import com.mongodb.ConnectionStatus;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBConnector;
import com.mongodb.DBDecoder;
import com.mongodb.DBPort;
import com.mongodb.DBPortPool;
import com.mongodb.DynamicConnectionStatus;
import com.mongodb.Mongo;
import com.mongodb.MongoAuthority;
import com.mongodb.MongoCredential;
import com.mongodb.MongoException;
import com.mongodb.MongosStatus;
import com.mongodb.OutMessage;
import com.mongodb.ReadPreference;
import com.mongodb.ReplicaSetStatus;
import com.mongodb.Response;
import com.mongodb.ServerAddress;
import com.mongodb.ServerError;
import com.mongodb.WriteConcern;
import com.mongodb.WriteResult;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBTCPConnector
implements DBConnector {
    static Logger _logger = Logger.getLogger(Bytes.LOGGER.getName() + ".tcp");
    private volatile DBPortPool _masterPortPool;
    private final Mongo _mongo;
    private DBPortPool.Holder _portHolder;
    private ConnectionStatus _connectionStatus;
    private final AtomicBoolean _closed = new AtomicBoolean(false);
    private volatile int _maxBsonObjectSize;
    private volatile Boolean _isMongosDirectConnection;
    MyPort _myPort = new MyPort();

    public DBTCPConnector(Mongo mongo) {
        this._mongo = mongo;
        this._portHolder = new DBPortPool.Holder(mongo._options);
        MongoAuthority.Type type = mongo.getAuthority().getType();
        if (type == MongoAuthority.Type.Direct) {
            this.setMasterAddress(mongo.getAuthority().getServerAddresses().get(0));
        } else if (type == MongoAuthority.Type.Set) {
            this._connectionStatus = new DynamicConnectionStatus(mongo, mongo.getAuthority().getServerAddresses());
        } else {
            throw new IllegalArgumentException("Unsupported authority type: " + (Object)((Object)type));
        }
    }

    public void start() {
        if (this._connectionStatus != null) {
            this._connectionStatus.start();
        }
    }

    @Override
    public void requestStart() {
        this._myPort.requestStart();
    }

    @Override
    public void requestDone() {
        this._myPort.requestDone();
    }

    @Override
    public void requestEnsureConnection() {
        this.checkMaster(false, true);
        this._myPort.requestEnsureConnection();
    }

    void _checkClosed() {
        if (this._closed.get()) {
            throw new IllegalStateException("this Mongo has been closed");
        }
    }

    WriteResult _checkWriteError(DB db, DBPort port, WriteConcern concern) throws IOException {
        CommandResult e = port.runCommand(db, concern.getCommand());
        e.throwOnError();
        return new WriteResult(e, concern);
    }

    @Override
    public WriteResult say(DB db, OutMessage m, WriteConcern concern) {
        return this.say(db, m, concern, null);
    }

    @Override
    public WriteResult say(DB db, OutMessage m, WriteConcern concern, ServerAddress hostNeeded) {
        if (concern == null) {
            throw new IllegalArgumentException("Write concern is null");
        }
        this._checkClosed();
        this.checkMaster(false, true);
        DBPort port = this._myPort.get(true, ReadPreference.primary(), hostNeeded);
        try {
            port.checkAuth(db.getMongo());
            port.say(m);
            if (concern.callGetLastError()) {
                WriteResult writeResult = this._checkWriteError(db, port, concern);
                return writeResult;
            }
            WriteResult writeResult = new WriteResult(db, port, concern);
            return writeResult;
        }
        catch (IOException ioe) {
            this._myPort.error(port, ioe);
            this._error(ioe, false);
            if (concern.raiseNetworkErrors()) {
                throw new MongoException.Network("Write operation to server " + port.host() + " failed on database " + db, ioe);
            }
            CommandResult res = new CommandResult(port.serverAddress());
            res.put("ok", (Object)false);
            res.put("$err", (Object)"NETWORK ERROR");
            WriteResult writeResult = new WriteResult(res, concern);
            return writeResult;
        }
        catch (MongoException me) {
            throw me;
        }
        catch (RuntimeException re) {
            this._myPort.error(port, re);
            throw re;
        }
        finally {
            this._myPort.done(port);
            m.doneWithMessage();
        }
    }

    @Override
    public Response call(DB db, DBCollection coll, OutMessage m, ServerAddress hostNeeded, DBDecoder decoder) {
        return this.call(db, coll, m, hostNeeded, 2, null, decoder);
    }

    @Override
    public Response call(DB db, DBCollection coll, OutMessage m, ServerAddress hostNeeded, int retries) {
        return this.call(db, coll, m, hostNeeded, retries, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response call(DB db, DBCollection coll, OutMessage m, ServerAddress hostNeeded, int retries, ReadPreference readPref, DBDecoder decoder) {
        try {
            Response response = this.innerCall(db, coll, m, hostNeeded, retries, readPref, decoder);
            return response;
        }
        finally {
            m.doneWithMessage();
        }
    }

    private Response innerCall(DB db, DBCollection coll, OutMessage m, ServerAddress hostNeeded, int retries, ReadPreference readPref, DBDecoder decoder) {
        if (readPref == null) {
            readPref = ReadPreference.primary();
        }
        if (readPref == ReadPreference.primary() && m.hasOption(4)) {
            readPref = ReadPreference.secondaryPreferred();
        }
        boolean secondaryOk = readPref != ReadPreference.primary();
        this._checkClosed();
        if (!secondaryOk || this.getReplicaSetStatus() == null) {
            this.checkMaster(false, !secondaryOk);
        }
        DBPort port = this._myPort.get(false, readPref, hostNeeded);
        Response res = null;
        boolean retry = false;
        try {
            port.checkAuth(db.getMongo());
            res = port.call(m, coll, decoder);
            if (res._responseTo != m.getId()) {
                throw new MongoException("ids don't match");
            }
        }
        catch (IOException ioe) {
            this._myPort.error(port, ioe);
            boolean bl = retry = retries > 0 && !coll._name.equals("$cmd") && !(ioe instanceof SocketTimeoutException) && this._error(ioe, secondaryOk);
            if (!retry) {
                throw new MongoException.Network("Read operation to server " + port.host() + " failed on database " + db, ioe);
            }
        }
        catch (RuntimeException re) {
            this._myPort.error(port, re);
            throw re;
        }
        finally {
            this._myPort.done(port);
        }
        if (retry) {
            return this.innerCall(db, coll, m, hostNeeded, retries - 1, readPref, decoder);
        }
        ServerError err = res.getError();
        if (err != null && err.isNotMasterError()) {
            this.checkMaster(true, true);
            if (retries <= 0) {
                throw new MongoException("not talking to master and retries used up");
            }
            return this.innerCall(db, coll, m, hostNeeded, retries - 1, readPref, decoder);
        }
        return res;
    }

    public ServerAddress getAddress() {
        DBPortPool pool = this._masterPortPool;
        return pool != null ? pool.getServerAddress() : null;
    }

    public List<ServerAddress> getAllAddress() {
        return this._mongo._authority.getServerAddresses();
    }

    public List<ServerAddress> getServerAddressList() {
        if (this._connectionStatus != null) {
            return this._connectionStatus.getServerAddressList();
        }
        ServerAddress master = this.getAddress();
        if (master != null) {
            ArrayList<ServerAddress> list = new ArrayList<ServerAddress>();
            list.add(master);
            return list;
        }
        return null;
    }

    public ReplicaSetStatus getReplicaSetStatus() {
        if (this._connectionStatus instanceof ReplicaSetStatus) {
            return (ReplicaSetStatus)this._connectionStatus;
        }
        if (this._connectionStatus instanceof DynamicConnectionStatus) {
            return ((DynamicConnectionStatus)this._connectionStatus).asReplicaSetStatus();
        }
        return null;
    }

    boolean isMongosConnection() {
        if (this._connectionStatus instanceof MongosStatus) {
            return true;
        }
        if (this._connectionStatus instanceof DynamicConnectionStatus) {
            return ((DynamicConnectionStatus)this._connectionStatus).asMongosStatus() != null;
        }
        if (this._isMongosDirectConnection == null) {
            this.initDirectConnection();
        }
        return this._isMongosDirectConnection != null ? this._isMongosDirectConnection : false;
    }

    public String getConnectPoint() {
        ServerAddress master = this.getAddress();
        return master != null ? master.toString() : null;
    }

    boolean _error(Throwable t, boolean secondaryOk) {
        if (this._connectionStatus == null) {
            return false;
        }
        if (this._connectionStatus.hasServerUp()) {
            this.checkMaster(true, !secondaryOk);
        }
        return this._connectionStatus.hasServerUp();
    }

    void checkMaster(boolean force, boolean failIfNoMaster) {
        if (this._connectionStatus != null) {
            if (this._masterPortPool == null || force) {
                ConnectionStatus.Node master = this._connectionStatus.ensureMaster();
                if (master == null) {
                    if (failIfNoMaster) {
                        throw new MongoException("can't find a master");
                    }
                } else {
                    this.setMaster(master);
                }
            }
        } else if (this._maxBsonObjectSize == 0) {
            this.initDirectConnection();
        }
    }

    synchronized void setMaster(ConnectionStatus.Node master) {
        if (this._closed.get()) {
            return;
        }
        this.setMasterAddress(master.getServerAddress());
        this._maxBsonObjectSize = master.getMaxBsonObjectSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initDirectConnection() {
        if (this._masterPortPool == null) {
            return;
        }
        DBPort port = this._masterPortPool.get();
        try {
            CommandResult res = port.runCommand(this._mongo.getDB("admin"), new BasicDBObject("isMaster", (Object)1));
            this._maxBsonObjectSize = res.containsField("maxBsonObjectSize") ? (Integer)res.get("maxBsonObjectSize") : 0x400000;
            String msg = res.getString("msg");
            this._isMongosDirectConnection = msg != null && msg.equals("isdbgrid");
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "Exception executing isMaster command on " + port.serverAddress(), e);
        }
        finally {
            port.getPool().done(port);
        }
    }

    private synchronized boolean setMasterAddress(ServerAddress addr) {
        DBPortPool newPool = this._portHolder.get(addr);
        if (newPool == this._masterPortPool) {
            return false;
        }
        if (this._masterPortPool != null) {
            _logger.log(Level.WARNING, "Primary switching from " + this._masterPortPool.getServerAddress() + " to " + addr);
        }
        this._masterPortPool = newPool;
        return true;
    }

    public String debugString() {
        StringBuilder buf = new StringBuilder("DBTCPConnector: ");
        if (this._connectionStatus != null) {
            buf.append("set : ").append(this._mongo._authority.getServerAddresses());
        } else {
            ServerAddress master = this.getAddress();
            buf.append(master).append(" ").append(master != null ? master.getSocketAddress() : null);
        }
        return buf.toString();
    }

    public void close() {
        this._closed.set(true);
        if (this._portHolder != null) {
            try {
                this._portHolder.close();
                this._portHolder = null;
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (this._connectionStatus != null) {
            try {
                this._connectionStatus.close();
                this._connectionStatus = null;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void updatePortPool(ServerAddress addr) {
        this._portHolder._pools.remove(addr);
    }

    public DBPortPool getDBPortPool(ServerAddress addr) {
        return this._portHolder.get(addr);
    }

    @Override
    public boolean isOpen() {
        return !this._closed.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommandResult authenticate(MongoCredential credentials) {
        this.checkMaster(false, true);
        DBPort port = this._myPort.get(false, ReadPreference.primaryPreferred(), null);
        try {
            CommandResult result = port.authenticate(this._mongo, credentials);
            this._mongo.getAuthority().getCredentialsStore().add(credentials);
            CommandResult commandResult = result;
            return commandResult;
        }
        finally {
            this._myPort.done(port);
        }
    }

    public int getMaxBsonObjectSize() {
        return this._maxBsonObjectSize;
    }

    MyPort getMyPort() {
        return this._myPort;
    }

    static class PinnedRequestStatus {
        DBPort requestPort;
        public int nestedBindings;

        PinnedRequestStatus() {
        }
    }

    class MyPort {
        private final ThreadLocal<PinnedRequestStatus> pinnedRequestStatusThreadLocal = new ThreadLocal();

        MyPort() {
        }

        DBPort get(boolean keep, ReadPreference readPref, ServerAddress hostNeeded) {
            DBPort port;
            DBPort pinnedRequestPort = this.getPinnedRequestPortForThread();
            if (hostNeeded != null) {
                if (pinnedRequestPort != null && pinnedRequestPort.serverAddress().equals(hostNeeded)) {
                    return pinnedRequestPort;
                }
                return DBTCPConnector.this._portHolder.get(hostNeeded).get();
            }
            if (pinnedRequestPort != null) {
                if (pinnedRequestPort.getPool() == DBTCPConnector.this._masterPortPool || !keep) {
                    return pinnedRequestPort;
                }
                pinnedRequestPort.getPool().done(pinnedRequestPort);
                this.setPinnedRequestPortForThread(null);
            }
            if (DBTCPConnector.this.getReplicaSetStatus() == null) {
                if (DBTCPConnector.this._masterPortPool == null) {
                    throw new MongoException("Rare case where master=null, probably all servers are down");
                }
                port = DBTCPConnector.this._masterPortPool.get();
            } else {
                ReplicaSetStatus.ReplicaSet replicaSet = DBTCPConnector.this.getReplicaSetStatus()._replicaSetHolder.get();
                ReplicaSetStatus.ReplicaSetNode node = readPref.getNode(replicaSet);
                if (node == null) {
                    throw new MongoException("No replica set members available in " + replicaSet + " for " + readPref.toDBObject().toString());
                }
                port = DBTCPConnector.this._portHolder.get(node.getServerAddress()).get();
            }
            if (this.threadHasPinnedRequest()) {
                this.setPinnedRequestPortForThread(port);
            }
            return port;
        }

        void done(DBPort port) {
            DBPort requestPort = this.getPinnedRequestPortForThread();
            if (port != requestPort) {
                port.getPool().done(port);
            }
        }

        void error(DBPort port, Exception e) {
            ConnectionStatus.Node newMaster;
            port.close();
            this.pinnedRequestStatusThreadLocal.remove();
            boolean recoverable = port.getPool().gotError(e);
            if (!recoverable && DBTCPConnector.this._connectionStatus != null && ((DBTCPConnector)DBTCPConnector.this)._masterPortPool._addr.equals(port.serverAddress()) && (newMaster = DBTCPConnector.this._connectionStatus.ensureMaster()) != null) {
                DBTCPConnector.this.setMaster(newMaster);
            }
        }

        void requestEnsureConnection() {
            if (!this.threadHasPinnedRequest()) {
                return;
            }
            if (this.getPinnedRequestPortForThread() != null) {
                return;
            }
            this.setPinnedRequestPortForThread(DBTCPConnector.this._masterPortPool.get());
        }

        void requestStart() {
            PinnedRequestStatus current = this.getPinnedRequestStatusForThread();
            if (current == null) {
                this.pinnedRequestStatusThreadLocal.set(new PinnedRequestStatus());
            } else {
                ++current.nestedBindings;
            }
        }

        void requestDone() {
            PinnedRequestStatus current = this.getPinnedRequestStatusForThread();
            if (current != null) {
                if (current.nestedBindings > 0) {
                    --current.nestedBindings;
                } else {
                    this.pinnedRequestStatusThreadLocal.remove();
                    if (current.requestPort != null) {
                        current.requestPort.getPool().done(current.requestPort);
                    }
                }
            }
        }

        PinnedRequestStatus getPinnedRequestStatusForThread() {
            return this.pinnedRequestStatusThreadLocal.get();
        }

        boolean threadHasPinnedRequest() {
            return this.pinnedRequestStatusThreadLocal.get() != null;
        }

        DBPort getPinnedRequestPortForThread() {
            return this.threadHasPinnedRequest() ? this.pinnedRequestStatusThreadLocal.get().requestPort : null;
        }

        void setPinnedRequestPortForThread(DBPort port) {
            this.pinnedRequestStatusThreadLocal.get().requestPort = port;
        }
    }
}

