/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.commandline;

import com.google.java.contract.Ensures;
import htsjdk.tribble.Feature;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Collections;
import org.broadinstitute.gatk.utils.commandline.RodBinding;

public final class RodBindingCollection<T extends Feature> {
    private final Class<T> type;
    private Collection<RodBinding<T>> rodBindings;

    public RodBindingCollection(Class<T> type, Collection<RodBinding<T>> rodBindings) {
        this.type = type;
        this.rodBindings = Collections.unmodifiableCollection(rodBindings);
    }

    public final Collection<RodBinding<T>> getRodBindings() {
        return this.rodBindings;
    }

    @Ensures(value={"result != null"})
    public final Class<T> getType() {
        return this.type;
    }

    public String toString() {
        return String.format("(RodBindingCollection %s)", this.getRodBindings());
    }

    public static Object createRodBindingCollectionOfType(Class<? extends Feature> type, Collection<RodBinding> rodBindings) {
        try {
            Constructor ctor = RodBindingCollection.class.getConstructor(Class.class, Collection.class);
            return ctor.newInstance(type, rodBindings);
        }
        catch (Exception e2) {
            throw new IllegalStateException("Failed to create a RodBindingCollection for type " + type);
        }
    }
}

